/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.ServiceDetail;
import org.uddi4j.transport.TransportException;

public class RegFindServiceUUIDAction
extends FindAction {
    public RegFindServiceUUIDAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(1));
        this.propertyTable_.put("queryStyleServices", String.valueOf(2));
    }

    @Override
    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String uuidKey = parser.getParameter("uuidKey");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (uuidKey != null) {
            this.propertyTable_.put("uuidServiceKey", uuidKey);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(uuidKey)) {
            inputsValid = false;
            formToolPI.flagError("uuidServiceKey");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_UUID_KEY"));
        }
        return inputsValid;
    }

    @Override
    public final boolean run() {
        MessageQueue messageQueue;
        UDDIPerspective uddiPerspective;
        block7: {
            uddiPerspective = this.controller_.getUDDIPerspective();
            messageQueue = uddiPerspective.getMessageQueue();
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            String uuidKey = (String)this.propertyTable_.get("uuidServiceKey");
            if (this.regNode_ == null) {
                this.regNode_ = this.getRegistryNode((Node)this.propertyTable_.get("refreshNode"));
            }
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            BusinessService[] bsArray = new BusinessService[1];
            ServiceDetail serviceDetail = proxy.get_serviceDetail(uuidKey);
            Vector bsVector = serviceDetail.getBusinessServiceVector();
            if (bsVector.size() <= 0) break block7;
            bsVector.toArray(bsArray);
            if (shouldAddQueryNode) {
                String queryName = (String)this.propertyTable_.get("queryName");
                this.queryElement_ = new QueryElement(bsArray, queryName, regElement.getModel());
                this.addQueryNode();
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_SERVICES_FOUND", String.valueOf(bsArray.length)));
            }
            this.propertyTable_.put("latestObject", bsArray[0]);
            return true;
        }
        try {
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_SERVICES_FOUND"));
        }
        catch (UDDIException e) {
            messageQueue.addMessage(uddiPerspective.getController().getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (TransportException e) {
            this.handleUnexpectedException(uddiPerspective, messageQueue, "TransportException", e);
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

