/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.connector;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.provider.AbstractTerminalConnector;
import org.eclipse.terminal.internal.connector.TerminalConnector;
import org.eclipse.terminal.internal.control.impl.TerminalMessages;

public class TerminalConnectorExtension {
    private static ITerminalConnector makeConnector(IConfigurationElement config) {
        String hidden;
        String name;
        String id = config.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = config.getAttribute("class");
        }
        if ((name = config.getAttribute("name")) == null || name.length() == 0) {
            name = id;
        }
        boolean isHidden = (hidden = config.getAttribute("hidden")) != null ? Boolean.parseBoolean(hidden) : false;
        TerminalConnector.Factory factory = () -> (AbstractTerminalConnector)config.createExecutableExtension("class");
        return new TerminalConnector(factory, id, name, isHidden);
    }

    public static ITerminalConnector makeTerminalConnector(String id) throws CoreException {
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.terminal.control.connectors");
        int i = 0;
        while (i < config.length) {
            if (id.equals(config[i].getAttribute("id"))) {
                return TerminalConnectorExtension.makeConnector(config[i]);
            }
            ++i;
        }
        throw new CoreException(Status.error((String)NLS.bind((String)TerminalMessages.TerminalConnectorExtension_e_no_connector_for_id, (Object)id)));
    }

    public static ITerminalConnector[] makeTerminalConnectors() {
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.terminal.control.connectors");
        ArrayList<ITerminalConnector> result = new ArrayList<ITerminalConnector>();
        int i = 0;
        while (i < config.length) {
            result.add(TerminalConnectorExtension.makeConnector(config[i]));
            ++i;
        }
        return result.toArray(new ITerminalConnector[result.size()]);
    }
}

