/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class LocaleFallbackData {
    public static final Map<String, String> DEFAULT_SCRIPT_TABLE = LocaleFallbackData.buildDefaultScriptTable();
    public static final Map<String, String> PARENT_LOCALE_TABLE = LocaleFallbackData.buildParentLocaleTable();

    LocaleFallbackData() {
    }

    private static Map<String, String> buildDefaultScriptTable() {
        HashMap<String, String> t = new HashMap<String, String>();
        t.put("aaf", "Mlym");
        t.put("aao", "Arab");
        t.put("aat", "Grek");
        t.put("ab", "Cyrl");
        t.put("abh", "Arab");
        t.put("abl", "Rjng");
        t.put("abq", "Cyrl");
        t.put("abv", "Arab");
        t.put("acm", "Arab");
        t.put("acq", "Arab");
        t.put("acw", "Arab");
        t.put("acx", "Arab");
        t.put("adf", "Arab");
        t.put("adx", "Tibt");
        t.put("ady", "Cyrl");
        t.put("ae", "Avst");
        t.put("aeb", "Arab");
        t.put("aec", "Arab");
        t.put("aee", "Arab");
        t.put("aeq", "Arab");
        t.put("afb", "Arab");
        t.put("agi", "Deva");
        t.put("agj", "Ethi");
        t.put("agx", "Cyrl");
        t.put("ahg", "Ethi");
        t.put("aho", "Ahom");
        t.put("ahr", "Deva");
        t.put("aib", "Arab");
        t.put("aii", "Syrc");
        t.put("aij", "Hebr");
        t.put("ain", "Kana");
        t.put("aio", "Mymr");
        t.put("aiq", "Arab");
        t.put("akk", "Xsux");
        t.put("akv", "Cyrl");
        t.put("alk", "Laoo");
        t.put("all", "Mlym");
        t.put("alr", "Cyrl");
        t.put("alt", "Cyrl");
        t.put("alw", "Ethi");
        t.put("am", "Ethi");
        t.put("ams", "Jpan");
        t.put("amw", "Syrc");
        t.put("ani", "Cyrl");
        t.put("anp", "Deva");
        t.put("anq", "Deva");
        t.put("anr", "Deva");
        t.put("anu", "Ethi");
        t.put("aot", "Beng");
        t.put("apc", "Arab");
        t.put("apd", "Arab");
        t.put("aph", "Deva");
        t.put("aqc", "Cyrl");
        t.put("ar", "Arab");
        t.put("arc", "Armi");
        t.put("arq", "Arab");
        t.put("ars", "Arab");
        t.put("ary", "Arab");
        t.put("arz", "Arab");
        t.put("as", "Beng");
        t.put("ase", "Sgnw");
        t.put("ask", "Arab");
        t.put("asr", "Deva");
        t.put("atn", "Arab");
        t.put("atv", "Cyrl");
        t.put("auj", "Arab");
        t.put("auz", "Arab");
        t.put("av", "Cyrl");
        t.put("avd", "Arab");
        t.put("avl", "Arab");
        t.put("awa", "Deva");
        t.put("awn", "Ethi");
        t.put("axm", "Armn");
        t.put("ayh", "Arab");
        t.put("ayl", "Arab");
        t.put("ayn", "Arab");
        t.put("ayp", "Arab");
        t.put("az_IQ", "Arab");
        t.put("az_IR", "Arab");
        t.put("az_RU", "Cyrl");
        t.put("azb", "Arab");
        t.put("ba", "Cyrl");
        t.put("bal", "Arab");
        t.put("bap", "Deva");
        t.put("bax", "Bamu");
        t.put("bbl", "Geor");
        t.put("bcq", "Ethi");
        t.put("bdv", "Orya");
        t.put("bdz", "Arab");
        t.put("be", "Cyrl");
        t.put("bee", "Deva");
        t.put("bej", "Arab");
        t.put("bfb", "Deva");
        t.put("bfq", "Taml");
        t.put("bft", "Arab");
        t.put("bfu", "Tibt");
        t.put("bfw", "Orya");
        t.put("bfy", "Deva");
        t.put("bfz", "Deva");
        t.put("bg", "Cyrl");
        t.put("bgc", "Deva");
        t.put("bgd", "Deva");
        t.put("bgn", "Arab");
        t.put("bgp", "Arab");
        t.put("bgq", "Deva");
        t.put("bgw", "Deva");
        t.put("bgx", "Grek");
        t.put("bha", "Deva");
        t.put("bhb", "Deva");
        t.put("bhd", "Deva");
        t.put("bhe", "Arab");
        t.put("bhh", "Cyrl");
        t.put("bhi", "Deva");
        t.put("bhj", "Deva");
        t.put("bhm", "Arab");
        t.put("bhn", "Syrc");
        t.put("bho", "Deva");
        t.put("bht", "Deva");
        t.put("bhu", "Deva");
        t.put("bix", "Deva");
        t.put("biy", "Deva");
        t.put("bjf", "Syrc");
        t.put("bjj", "Deva");
        t.put("bjm", "Arab");
        t.put("bkk", "Tibt");
        t.put("blk", "Mymr");
        t.put("blt", "Tavt");
        t.put("bmj", "Deva");
        t.put("bn", "Beng");
        t.put("bns", "Deva");
        t.put("bo", "Tibt");
        t.put("bph", "Cyrl");
        t.put("bpx", "Deva");
        t.put("bpy", "Beng");
        t.put("bqi", "Arab");
        t.put("bra", "Deva");
        t.put("brb", "Khmr");
        t.put("brd", "Deva");
        t.put("brh", "Arab");
        t.put("brk", "Arab");
        t.put("bro", "Tibt");
        t.put("brv", "Laoo");
        t.put("brw", "Knda");
        t.put("brx", "Deva");
        t.put("bsh", "Arab");
        t.put("bsk", "Arab");
        t.put("bst", "Ethi");
        t.put("btd", "Batk");
        t.put("btm", "Batk");
        t.put("btv", "Deva");
        t.put("bua", "Cyrl");
        t.put("bwe", "Mymr");
        t.put("bxm", "Cyrl");
        t.put("bxu", "Mong");
        t.put("byh", "Deva");
        t.put("byn", "Ethi");
        t.put("byw", "Deva");
        t.put("bzi", "Thai");
        t.put("cbn", "Thai");
        t.put("ccp", "Cakm");
        t.put("cde", "Telu");
        t.put("cdh", "Deva");
        t.put("cdi", "Gujr");
        t.put("cdj", "Deva");
        t.put("cdm", "Deva");
        t.put("cdn", "Deva");
        t.put("cdo", "Hans");
        t.put("cdz", "Beng");
        t.put("ce", "Cyrl");
        t.put("cgk", "Tibt");
        t.put("chg", "Arab");
        t.put("chm", "Cyrl");
        t.put("chr", "Cher");
        t.put("chx", "Deva");
        t.put("cih", "Deva");
        t.put("cja", "Arab");
        t.put("cji", "Cyrl");
        t.put("cjm", "Cham");
        t.put("cjy", "Hans");
        t.put("ckb", "Arab");
        t.put("ckt", "Cyrl");
        t.put("clh", "Arab");
        t.put("clw", "Cyrl");
        t.put("cmg", "Soyo");
        t.put("cna", "Tibt");
        t.put("cnp", "Hans");
        t.put("cog", "Thai");
        t.put("cop", "Copt");
        t.put("cpg", "Grek");
        t.put("cr", "Cans");
        t.put("crh", "Cyrl");
        t.put("crj", "Cans");
        t.put("crk", "Cans");
        t.put("crl", "Cans");
        t.put("crm", "Cans");
        t.put("csh", "Mymr");
        t.put("csp", "Hans");
        t.put("csw", "Cans");
        t.put("ctd", "Pauc");
        t.put("ctg", "Beng");
        t.put("ctn", "Deva");
        t.put("ctt", "Taml");
        t.put("cty", "Taml");
        t.put("cu", "Cyrl");
        t.put("cuu", "Lana");
        t.put("cv", "Cyrl");
        t.put("czh", "Hans");
        t.put("czk", "Hebr");
        t.put("daq", "Deva");
        t.put("dar", "Cyrl");
        t.put("dcc", "Arab");
        t.put("ddo", "Cyrl");
        t.put("def", "Arab");
        t.put("deh", "Arab");
        t.put("der", "Beng");
        t.put("dgl", "Arab");
        t.put("dhi", "Deva");
        t.put("dhn", "Gujr");
        t.put("dho", "Gujr");
        t.put("dhw", "Deva");
        t.put("dka", "Tibt");
        t.put("dlg", "Cyrl");
        t.put("dmf", "Medf");
        t.put("dmk", "Arab");
        t.put("dml", "Arab");
        t.put("dng", "Cyrl");
        t.put("dnu", "Mymr");
        t.put("dnv", "Mymr");
        t.put("doi", "Deva");
        t.put("dox", "Ethi");
        t.put("dre", "Tibt");
        t.put("drq", "Deva");
        t.put("drs", "Ethi");
        t.put("dry", "Deva");
        t.put("dso", "Orya");
        t.put("dty", "Deva");
        t.put("dub", "Gujr");
        t.put("duh", "Deva");
        t.put("dus", "Deva");
        t.put("dv", "Thaa");
        t.put("dwk", "Orya");
        t.put("dwz", "Deva");
        t.put("dz", "Tibt");
        t.put("dzl", "Tibt");
        t.put("ecr", "Grek");
        t.put("ecy", "Cprt");
        t.put("egy", "Egyp");
        t.put("eky", "Kali");
        t.put("el", "Grek");
        t.put("emg", "Deva");
        t.put("emu", "Deva");
        t.put("enf", "Cyrl");
        t.put("enh", "Cyrl");
        t.put("era", "Taml");
        t.put("esg", "Gonm");
        t.put("esh", "Arab");
        t.put("ett", "Ital");
        t.put("eve", "Cyrl");
        t.put("evn", "Cyrl");
        t.put("fa", "Arab");
        t.put("fay", "Arab");
        t.put("faz", "Arab");
        t.put("fia", "Arab");
        t.put("fmu", "Deva");
        t.put("fub", "Arab");
        t.put("gan", "Hans");
        t.put("gaq", "Orya");
        t.put("gas", "Gujr");
        t.put("gau", "Telu");
        t.put("gbj", "Orya");
        t.put("gbk", "Deva");
        t.put("gbl", "Gujr");
        t.put("gbm", "Deva");
        t.put("gbz", "Arab");
        t.put("gdb", "Orya");
        t.put("gdo", "Cyrl");
        t.put("gdx", "Deva");
        t.put("gez", "Ethi");
        t.put("ggg", "Arab");
        t.put("gha", "Arab");
        t.put("ghe", "Deva");
        t.put("gho", "Tfng");
        t.put("ghr", "Arab");
        t.put("ght", "Tibt");
        t.put("gig", "Arab");
        t.put("gin", "Cyrl");
        t.put("gjk", "Arab");
        t.put("gju", "Arab");
        t.put("gld", "Cyrl");
        t.put("glh", "Arab");
        t.put("glk", "Arab");
        t.put("gml", "Latf");
        t.put("gmv", "Ethi");
        t.put("gmy", "Linb");
        t.put("goe", "Tibt");
        t.put("gof", "Ethi");
        t.put("goj", "Deva");
        t.put("gok", "Deva");
        t.put("gon", "Deva");
        t.put("got", "Goth");
        t.put("gra", "Deva");
        t.put("grc", "Grek");
        t.put("grr", "Arab");
        t.put("grt", "Beng");
        t.put("gru", "Ethi");
        t.put("gu", "Gujr");
        t.put("gvr", "Deva");
        t.put("gwc", "Arab");
        t.put("gwf", "Arab");
        t.put("gwt", "Arab");
        t.put("gyo", "Deva");
        t.put("gzi", "Arab");
        t.put("ha_CM", "Arab");
        t.put("ha_SD", "Arab");
        t.put("hac", "Arab");
        t.put("hak", "Hans");
        t.put("hak_TW", "Hant");
        t.put("har", "Ethi");
        t.put("haz", "Arab");
        t.put("hbo", "Hebr");
        t.put("hdy", "Ethi");
        t.put("he", "Hebr");
        t.put("hi", "Deva");
        t.put("hif", "Deva");
        t.put("hii", "Takr");
        t.put("hit", "Xsux");
        t.put("hkh", "Arab");
        t.put("hlb", "Deva");
        t.put("hlu", "Hluw");
        t.put("hmd", "Plrd");
        t.put("hmj", "Bopo");
        t.put("hmq", "Bopo");
        t.put("hnd", "Arab");
        t.put("hne", "Deva");
        t.put("hnj", "Hmnp");
        t.put("hnm", "Hans");
        t.put("hno", "Arab");
        t.put("hoc", "Deva");
        t.put("hoh", "Arab");
        t.put("hoj", "Deva");
        t.put("how", "Hani");
        t.put("hoy", "Deva");
        t.put("hpo", "Mymr");
        t.put("hrt", "Syrc");
        t.put("hrz", "Arab");
        t.put("hsn", "Hans");
        t.put("hss", "Arab");
        t.put("htx", "Xsux");
        t.put("hut", "Deva");
        t.put("huy", "Hebr");
        t.put("huz", "Cyrl");
        t.put("hy", "Armn");
        t.put("hyw", "Armn");
        t.put("ii", "Yiii");
        t.put("imy", "Lyci");
        t.put("inh", "Cyrl");
        t.put("int", "Mymr");
        t.put("ior", "Ethi");
        t.put("iru", "Taml");
        t.put("isk", "Arab");
        t.put("itk", "Hebr");
        t.put("itl", "Cyrl");
        t.put("iu", "Cans");
        t.put("iw", "Hebr");
        t.put("ja", "Jpan");
        t.put("jad", "Arab");
        t.put("jat", "Arab");
        t.put("jbe", "Hebr");
        t.put("jbn", "Arab");
        t.put("jct", "Cyrl");
        t.put("jda", "Tibt");
        t.put("jdg", "Arab");
        t.put("jdt", "Cyrl");
        t.put("jee", "Deva");
        t.put("jge", "Geor");
        t.put("ji", "Hebr");
        t.put("jje", "Hang");
        t.put("jkm", "Mymr");
        t.put("jml", "Deva");
        t.put("jna", "Takr");
        t.put("jnd", "Arab");
        t.put("jnl", "Deva");
        t.put("jns", "Deva");
        t.put("jog", "Arab");
        t.put("jpa", "Hebr");
        t.put("jpr", "Hebr");
        t.put("jrb", "Hebr");
        t.put("jul", "Deva");
        t.put("jun", "Orya");
        t.put("juy", "Orya");
        t.put("jya", "Tibt");
        t.put("jye", "Hebr");
        t.put("ka", "Geor");
        t.put("kaa", "Cyrl");
        t.put("kap", "Cyrl");
        t.put("kaw", "Bali");
        t.put("kbd", "Cyrl");
        t.put("kbg", "Tibt");
        t.put("kbu", "Arab");
        t.put("kby", "Arab");
        t.put("kca", "Cyrl");
        t.put("kcy", "Arab");
        t.put("kdq", "Beng");
        t.put("kdt", "Thai");
        t.put("ket", "Cyrl");
        t.put("kev", "Mlym");
        t.put("kex", "Deva");
        t.put("key", "Telu");
        t.put("kfa", "Knda");
        t.put("kfb", "Deva");
        t.put("kfc", "Telu");
        t.put("kfd", "Knda");
        t.put("kfe", "Taml");
        t.put("kfg", "Knda");
        t.put("kfh", "Mlym");
        t.put("kfi", "Taml");
        t.put("kfk", "Deva");
        t.put("kfm", "Arab");
        t.put("kfp", "Deva");
        t.put("kfq", "Deva");
        t.put("kfr", "Deva");
        t.put("kfs", "Deva");
        t.put("kfu", "Deva");
        t.put("kfx", "Deva");
        t.put("kfy", "Deva");
        t.put("kgj", "Deva");
        t.put("kgy", "Tibt");
        t.put("khb", "Talu");
        t.put("khf", "Thai");
        t.put("khg", "Tibt");
        t.put("khn", "Deva");
        t.put("kho", "Brah");
        t.put("kht", "Mymr");
        t.put("khv", "Cyrl");
        t.put("khw", "Arab");
        t.put("kif", "Deva");
        t.put("kim", "Cyrl");
        t.put("kip", "Deva");
        t.put("kjg", "Laoo");
        t.put("kjh", "Cyrl");
        t.put("kjl", "Deva");
        t.put("kjo", "Deva");
        t.put("kjp", "Mymr");
        t.put("kjt", "Thai");
        t.put("kjz", "Tibt");
        t.put("kk", "Cyrl");
        t.put("kk_AF", "Arab");
        t.put("kk_CN", "Arab");
        t.put("kk_IR", "Arab");
        t.put("kk_MN", "Arab");
        t.put("kkf", "Tibt");
        t.put("kkh", "Lana");
        t.put("kkt", "Deva");
        t.put("kle", "Deva");
        t.put("klj", "Arab");
        t.put("klr", "Deva");
        t.put("km", "Khmr");
        t.put("kmj", "Deva");
        t.put("kmz", "Arab");
        t.put("kn", "Knda");
        t.put("knn", "Deva");
        t.put("ko", "Kore");
        t.put("koi", "Cyrl");
        t.put("kok", "Deva");
        t.put("kpt", "Cyrl");
        t.put("kpy", "Cyrl");
        t.put("kqd", "Syrc");
        t.put("kqy", "Ethi");
        t.put("kra", "Deva");
        t.put("krc", "Cyrl");
        t.put("krk", "Cyrl");
        t.put("krr", "Khmr");
        t.put("kru", "Deva");
        t.put("krv", "Khmr");
        t.put("ks", "Arab");
        t.put("ksu", "Mymr");
        t.put("ksw", "Mymr");
        t.put("ksz", "Deva");
        t.put("ktb", "Ethi");
        t.put("kte", "Deva");
        t.put("ktl", "Arab");
        t.put("ktp", "Plrd");
        t.put("ku_AM", "Cyrl");
        t.put("ku_AZ", "Cyrl");
        t.put("ku_GE", "Cyrl");
        t.put("ku_IQ", "Arab");
        t.put("ku_IR", "Arab");
        t.put("ku_LB", "Arab");
        t.put("ku_TM", "Cyrl");
        t.put("kuf", "Laoo");
        t.put("kum", "Cyrl");
        t.put("kv", "Cyrl");
        t.put("kva", "Cyrl");
        t.put("kvq", "Mymr");
        t.put("kvt", "Mymr");
        t.put("kvx", "Arab");
        t.put("kvy", "Kali");
        t.put("kwx", "Deva");
        t.put("kxf", "Mymr");
        t.put("kxk", "Mymr");
        t.put("kxm", "Thai");
        t.put("kxp", "Arab");
        t.put("ky", "Cyrl");
        t.put("ky_CN", "Arab");
        t.put("kyu", "Kali");
        t.put("kyv", "Deva");
        t.put("kyw", "Deva");
        t.put("lab", "Lina");
        t.put("lad", "Hebr");
        t.put("lae", "Deva");
        t.put("lah", "Arab");
        t.put("lbe", "Cyrl");
        t.put("lbf", "Deva");
        t.put("lbj", "Tibt");
        t.put("lbm", "Deva");
        t.put("lbo", "Laoo");
        t.put("lbr", "Deva");
        t.put("lcp", "Thai");
        t.put("lep", "Lepc");
        t.put("lez", "Cyrl");
        t.put("lhm", "Deva");
        t.put("lhs", "Syrc");
        t.put("lif", "Deva");
        t.put("lis", "Lisu");
        t.put("lkh", "Tibt");
        t.put("lki", "Arab");
        t.put("lmh", "Deva");
        t.put("lmn", "Telu");
        t.put("lo", "Laoo");
        t.put("loy", "Deva");
        t.put("lpo", "Plrd");
        t.put("lrc", "Arab");
        t.put("lrk", "Arab");
        t.put("lrl", "Arab");
        t.put("lsa", "Arab");
        t.put("lsd", "Hebr");
        t.put("lss", "Arab");
        t.put("ltc", "Hant");
        t.put("luh", "Hans");
        t.put("luk", "Tibt");
        t.put("luu", "Deva");
        t.put("luv", "Arab");
        t.put("luz", "Arab");
        t.put("lwl", "Thai");
        t.put("lwm", "Thai");
        t.put("lya", "Tibt");
        t.put("lzh", "Hant");
        t.put("lzz_GE", "Geor");
        t.put("mag", "Deva");
        t.put("mai", "Deva");
        t.put("mby", "Arab");
        t.put("mde", "Arab");
        t.put("mdf", "Cyrl");
        t.put("mdx", "Ethi");
        t.put("mdy", "Ethi");
        t.put("mey", "Arab");
        t.put("mfa", "Arab");
        t.put("mfi", "Arab");
        t.put("mga", "Latg");
        t.put("mgp", "Deva");
        t.put("mhj", "Arab");
        t.put("mid", "Mand");
        t.put("mjl", "Deva");
        t.put("mjq", "Mlym");
        t.put("mjr", "Mlym");
        t.put("mjt", "Deva");
        t.put("mju", "Telu");
        t.put("mjv", "Mlym");
        t.put("mjz", "Deva");
        t.put("mk", "Cyrl");
        t.put("mkb", "Deva");
        t.put("mke", "Deva");
        t.put("mki", "Arab");
        t.put("mkm", "Thai");
        t.put("ml", "Mlym");
        t.put("mlf", "Thai");
        t.put("mn", "Cyrl");
        t.put("mn_CN", "Mong");
        t.put("mnc", "Mong");
        t.put("mni", "Beng");
        t.put("mnj", "Arab");
        t.put("mns", "Cyrl");
        t.put("mnw", "Mymr");
        t.put("mpz", "Thai");
        t.put("mr", "Deva");
        t.put("mra", "Thai");
        t.put("mrd", "Deva");
        t.put("mrj", "Cyrl");
        t.put("mro", "Mroo");
        t.put("mrr", "Deva");
        t.put("ms_CC", "Arab");
        t.put("mtm", "Cyrl");
        t.put("mtr", "Deva");
        t.put("mud", "Cyrl");
        t.put("muk", "Tibt");
        t.put("mut", "Deva");
        t.put("muv", "Taml");
        t.put("muz", "Ethi");
        t.put("mve", "Arab");
        t.put("mvf", "Mong");
        t.put("mvy", "Arab");
        t.put("mvz", "Ethi");
        t.put("mwr", "Deva");
        t.put("mwt", "Mymr");
        t.put("mww", "Hmnp");
        t.put("my", "Mymr");
        t.put("mym", "Ethi");
        t.put("myv", "Cyrl");
        t.put("myz", "Mand");
        t.put("mzb", "Arab");
        t.put("mzn", "Arab");
        t.put("nan", "Hans");
        t.put("nan_MO", "Hant");
        t.put("nan_TW", "Hant");
        t.put("nao", "Deva");
        t.put("ncd", "Deva");
        t.put("ncq", "Laoo");
        t.put("ndf", "Cyrl");
        t.put("ne", "Deva");
        t.put("neg", "Cyrl");
        t.put("neh", "Tibt");
        t.put("nei", "Xsux");
        t.put("new", "Deva");
        t.put("ngt", "Laoo");
        t.put("nio", "Cyrl");
        t.put("nit", "Telu");
        t.put("niv", "Cyrl");
        t.put("nli", "Arab");
        t.put("nlm", "Arab");
        t.put("nlx", "Deva");
        t.put("nmm", "Deva");
        t.put("nnp", "Wcho");
        t.put("nod", "Lana");
        t.put("noe", "Deva");
        t.put("nog", "Cyrl");
        t.put("noi", "Deva");
        t.put("non", "Runr");
        t.put("nos", "Yiii");
        t.put("npb", "Tibt");
        t.put("nqo", "Nkoo");
        t.put("nrn", "Runr");
        t.put("nsd", "Yiii");
        t.put("nsf", "Yiii");
        t.put("nsk", "Cans");
        t.put("nst", "Tnsa");
        t.put("nsv", "Yiii");
        t.put("nty", "Yiii");
        t.put("ntz", "Arab");
        t.put("nwc", "Newa");
        t.put("nwx", "Deva");
        t.put("nyl", "Thai");
        t.put("nyq", "Arab");
        t.put("nyw", "Thai");
        t.put("oaa", "Cyrl");
        t.put("oac", "Cyrl");
        t.put("oar", "Syrc");
        t.put("oav", "Geor");
        t.put("obm", "Phnx");
        t.put("obr", "Mymr");
        t.put("odk", "Arab");
        t.put("oht", "Xsux");
        t.put("oj", "Cans");
        t.put("ojs", "Cans");
        t.put("okm", "Hang");
        t.put("oko", "Hani");
        t.put("okz", "Khmr");
        t.put("ola", "Deva");
        t.put("ole", "Tibt");
        t.put("omk", "Cyrl");
        t.put("omp", "Mtei");
        t.put("omr", "Modi");
        t.put("omx", "Mymr");
        t.put("oon", "Deva");
        t.put("or", "Orya");
        t.put("ort", "Telu");
        t.put("oru", "Arab");
        t.put("orv", "Cyrl");
        t.put("os", "Cyrl");
        t.put("osa", "Osge");
        t.put("osc", "Ital");
        t.put("osi", "Java");
        t.put("ota", "Arab");
        t.put("otb", "Tibt");
        t.put("otk", "Orkh");
        t.put("oty", "Gran");
        t.put("oui", "Ougr");
        t.put("oyb", "Laoo");
        t.put("pa", "Guru");
        t.put("pa_PK", "Arab");
        t.put("pal", "Phli");
        t.put("paq", "Cyrl");
        t.put("pbt", "Arab");
        t.put("pcb", "Khmr");
        t.put("pce", "Mymr");
        t.put("pcf", "Mlym");
        t.put("pcg", "Mlym");
        t.put("pch", "Deva");
        t.put("pci", "Deva");
        t.put("pcj", "Telu");
        t.put("peg", "Orya");
        t.put("peo", "Xpeo");
        t.put("pgd", "Khar");
        t.put("pgg", "Deva");
        t.put("pgl", "Ogam");
        t.put("pgn", "Ital");
        t.put("phd", "Deva");
        t.put("phk", "Mymr");
        t.put("phl", "Arab");
        t.put("phn", "Phnx");
        t.put("pho", "Laoo");
        t.put("phr", "Arab");
        t.put("pht", "Thai");
        t.put("phu", "Thai");
        t.put("phv", "Arab");
        t.put("phw", "Deva");
        t.put("pi_IN", "Deva");
        t.put("pi_LK", "Sinh");
        t.put("pi_MM", "Mymr");
        t.put("pi_TH", "Thai");
        t.put("pka", "Brah");
        t.put("pkr", "Mlym");
        t.put("plk", "Arab");
        t.put("pll", "Mymr");
        t.put("pmh", "Brah");
        t.put("pnt", "Grek");
        t.put("pnt_RU", "Cyrl");
        t.put("prc", "Arab");
        t.put("prd", "Arab");
        t.put("prt", "Thai");
        t.put("prx", "Arab");
        t.put("ps", "Arab");
        t.put("psh", "Arab");
        t.put("psi", "Arab");
        t.put("pst", "Arab");
        t.put("psu", "Brah");
        t.put("pum", "Deva");
        t.put("pwo", "Mymr");
        t.put("pwr", "Deva");
        t.put("pww", "Thai");
        t.put("pyx", "Mymr");
        t.put("qxq", "Arab");
        t.put("raa", "Deva");
        t.put("rab", "Deva");
        t.put("raf", "Deva");
        t.put("rah", "Beng");
        t.put("raj", "Deva");
        t.put("rav", "Deva");
        t.put("rbb", "Mymr");
        t.put("rdb", "Arab");
        t.put("rei", "Orya");
        t.put("rhg", "Rohg");
        t.put("rji", "Deva");
        t.put("rjs", "Deva");
        t.put("rka", "Khmr");
        t.put("rki", "Mymr");
        t.put("rkt", "Beng");
        t.put("rmi", "Armn");
        t.put("rmt", "Arab");
        t.put("rmz", "Mymr");
        t.put("rsk", "Cyrl");
        t.put("rtw", "Deva");
        t.put("ru", "Cyrl");
        t.put("rue", "Cyrl");
        t.put("rut", "Cyrl");
        t.put("rwr", "Deva");
        t.put("ryu", "Kana");
        t.put("sa", "Deva");
        t.put("sah", "Cyrl");
        t.put("sam", "Samr");
        t.put("sat", "Olck");
        t.put("saz", "Saur");
        t.put("sbn", "Arab");
        t.put("sbu", "Tibt");
        t.put("sck", "Deva");
        t.put("scl", "Arab");
        t.put("scp", "Deva");
        t.put("sct", "Laoo");
        t.put("scu", "Takr");
        t.put("scx", "Grek");
        t.put("sd", "Arab");
        t.put("sd_IN", "Deva");
        t.put("sdb", "Arab");
        t.put("sdf", "Arab");
        t.put("sdg", "Arab");
        t.put("sdh", "Arab");
        t.put("sdr", "Beng");
        t.put("sds", "Arab");
        t.put("sel", "Cyrl");
        t.put("sfm", "Plrd");
        t.put("sgh", "Cyrl");
        t.put("sgj", "Deva");
        t.put("sgr", "Arab");
        t.put("sgt", "Tibt");
        t.put("sgw", "Ethi");
        t.put("sgy", "Arab");
        t.put("shd", "Arab");
        t.put("shi", "Tfng");
        t.put("shm", "Arab");
        t.put("shn", "Mymr");
        t.put("shu", "Arab");
        t.put("shv", "Arab");
        t.put("si", "Sinh");
        t.put("sia", "Cyrl");
        t.put("sip", "Tibt");
        t.put("siy", "Arab");
        t.put("siz", "Arab");
        t.put("sjc", "Hans");
        t.put("sjd", "Cyrl");
        t.put("sjp", "Deva");
        t.put("sjt", "Cyrl");
        t.put("skb", "Thai");
        t.put("skj", "Deva");
        t.put("skr", "Arab");
        t.put("smh", "Yiii");
        t.put("smp", "Samr");
        t.put("smu", "Khmr");
        t.put("smy", "Arab");
        t.put("soa", "Tavt");
        t.put("sog", "Sogd");
        t.put("soi", "Deva");
        t.put("sou", "Thai");
        t.put("spt", "Tibt");
        t.put("spv", "Orya");
        t.put("sqo", "Arab");
        t.put("sqq", "Laoo");
        t.put("sqt", "Arab");
        t.put("sr", "Cyrl");
        t.put("srb", "Sora");
        t.put("srh", "Arab");
        t.put("srx", "Deva");
        t.put("srz", "Arab");
        t.put("ssh", "Arab");
        t.put("sss", "Laoo");
        t.put("sts", "Arab");
        t.put("stu", "Lana");
        t.put("stu_CN", "Tale");
        t.put("stv", "Ethi");
        t.put("sty", "Cyrl");
        t.put("suz", "Deva");
        t.put("sva", "Geor");
        t.put("swb", "Arab");
        t.put("swi", "Hani");
        t.put("swv", "Deva");
        t.put("sxu", "Runr");
        t.put("syc", "Syrc");
        t.put("syl", "Beng");
        t.put("syn", "Syrc");
        t.put("syr", "Syrc");
        t.put("syw", "Deva");
        t.put("ta", "Taml");
        t.put("tab", "Cyrl");
        t.put("taj", "Deva");
        t.put("tbk", "Tagb");
        t.put("tcn", "Deva");
        t.put("tco", "Mymr");
        t.put("tcx", "Taml");
        t.put("tcy", "Knda");
        t.put("tda", "Tfng");
        t.put("tdb", "Deva");
        t.put("tdd", "Tale");
        t.put("tdg", "Deva");
        t.put("tdh", "Deva");
        t.put("te", "Telu");
        t.put("tes", "Java");
        t.put("tg", "Cyrl");
        t.put("tg_PK", "Arab");
        t.put("tge", "Deva");
        t.put("tgf", "Tibt");
        t.put("th", "Thai");
        t.put("the", "Deva");
        t.put("thf", "Deva");
        t.put("thi", "Tale");
        t.put("thl", "Deva");
        t.put("thm", "Thai");
        t.put("thq", "Deva");
        t.put("thr", "Deva");
        t.put("ths", "Deva");
        t.put("ti", "Ethi");
        t.put("tig", "Ethi");
        t.put("tij", "Deva");
        t.put("tin", "Cyrl");
        t.put("tjl", "Mymr");
        t.put("tjo", "Arab");
        t.put("tkb", "Deva");
        t.put("tks", "Arab");
        t.put("tkt", "Deva");
        t.put("tmr", "Syrc");
        t.put("tnv", "Cakm");
        t.put("tov", "Arab");
        t.put("tpu", "Khmr");
        t.put("tra", "Arab");
        t.put("trg", "Hebr");
        t.put("trm", "Arab");
        t.put("trw", "Arab");
        t.put("tsd", "Grek");
        t.put("tsj", "Tibt");
        t.put("tt", "Cyrl");
        t.put("tth", "Laoo");
        t.put("tto", "Laoo");
        t.put("tts", "Thai");
        t.put("ttz", "Deva");
        t.put("tvn", "Mymr");
        t.put("twm", "Tibt");
        t.put("txg", "Tang");
        t.put("txo", "Toto");
        t.put("tyr", "Tavt");
        t.put("tyv", "Cyrl");
        t.put("ude", "Cyrl");
        t.put("udg", "Mlym");
        t.put("udi", "Cyrl");
        t.put("udm", "Cyrl");
        t.put("ug", "Arab");
        t.put("ug_KZ", "Cyrl");
        t.put("ug_MN", "Cyrl");
        t.put("uga", "Ugar");
        t.put("ugh", "Cyrl");
        t.put("ugo", "Thai");
        t.put("uk", "Cyrl");
        t.put("uki", "Orya");
        t.put("ulc", "Cyrl");
        t.put("unr", "Beng");
        t.put("unr_NP", "Deva");
        t.put("unx", "Beng");
        t.put("ur", "Arab");
        t.put("urk", "Thai");
        t.put("ush", "Arab");
        t.put("uum", "Grek");
        t.put("uz_AF", "Arab");
        t.put("uz_CN", "Cyrl");
        t.put("uzs", "Arab");
        t.put("vaa", "Taml");
        t.put("vaf", "Arab");
        t.put("vah", "Deva");
        t.put("vai", "Vaii");
        t.put("vas", "Deva");
        t.put("vav", "Deva");
        t.put("vay", "Deva");
        t.put("vgr", "Arab");
        t.put("vjk", "Deva");
        t.put("vmd", "Knda");
        t.put("vmh", "Arab");
        t.put("wal", "Ethi");
        t.put("wbk", "Arab");
        t.put("wbq", "Telu");
        t.put("wbr", "Deva");
        t.put("wle", "Ethi");
        t.put("wlo", "Arab");
        t.put("wme", "Deva");
        t.put("wne", "Arab");
        t.put("wni", "Arab");
        t.put("wsg", "Gong");
        t.put("wsv", "Arab");
        t.put("wtm", "Deva");
        t.put("wuu", "Hans");
        t.put("xag", "Aghb");
        t.put("xal", "Cyrl");
        t.put("xan", "Ethi");
        t.put("xas", "Cyrl");
        t.put("xco", "Chrs");
        t.put("xcr", "Cari");
        t.put("xdq", "Cyrl");
        t.put("xhe", "Arab");
        t.put("xhm", "Khmr");
        t.put("xis", "Orya");
        t.put("xka", "Arab");
        t.put("xkc", "Arab");
        t.put("xkf", "Tibt");
        t.put("xkj", "Arab");
        t.put("xkp", "Arab");
        t.put("xlc", "Lyci");
        t.put("xld", "Lydi");
        t.put("xly", "Elym");
        t.put("xmf", "Geor");
        t.put("xmn", "Mani");
        t.put("xmr", "Merc");
        t.put("xna", "Narb");
        t.put("xnr", "Deva");
        t.put("xpg", "Grek");
        t.put("xpi", "Ogam");
        t.put("xpm", "Cyrl");
        t.put("xpr", "Prti");
        t.put("xrm", "Cyrl");
        t.put("xrn", "Cyrl");
        t.put("xsa", "Sarb");
        t.put("xsd", "Sidt");
        t.put("xsr", "Deva");
        t.put("xtq", "Brah");
        t.put("xub", "Taml");
        t.put("xuj", "Taml");
        t.put("xve", "Ital");
        t.put("xvi", "Arab");
        t.put("xwo", "Cyrl");
        t.put("xzh", "Marc");
        t.put("yai", "Cyrl");
        t.put("ybh", "Deva");
        t.put("ybi", "Deva");
        t.put("ydg", "Arab");
        t.put("yea", "Mlym");
        t.put("yej", "Grek");
        t.put("yeu", "Telu");
        t.put("ygp", "Plrd");
        t.put("yhd", "Hebr");
        t.put("yi", "Hebr");
        t.put("yig", "Yiii");
        t.put("yih", "Hebr");
        t.put("yiv", "Yiii");
        t.put("ykg", "Cyrl");
        t.put("ykh", "Cyrl");
        t.put("yna", "Plrd");
        t.put("ynk", "Cyrl");
        t.put("yoi", "Jpan");
        t.put("yoy", "Thai");
        t.put("yrk", "Cyrl");
        t.put("ysd", "Yiii");
        t.put("ysn", "Yiii");
        t.put("ysp", "Yiii");
        t.put("ysr", "Cyrl");
        t.put("ysy", "Plrd");
        t.put("yud", "Hebr");
        t.put("yue", "Hant");
        t.put("yue_CN", "Hans");
        t.put("yug", "Cyrl");
        t.put("yux", "Cyrl");
        t.put("ywq", "Plrd");
        t.put("ywu", "Plrd");
        t.put("zau", "Tibt");
        t.put("zba", "Arab");
        t.put("zch", "Hani");
        t.put("zdj", "Arab");
        t.put("zeh", "Hani");
        t.put("zen", "Tfng");
        t.put("zgb", "Hani");
        t.put("zgh", "Tfng");
        t.put("zgm", "Hani");
        t.put("zgn", "Hani");
        t.put("zh", "Hans");
        t.put("zh_AU", "Hant");
        t.put("zh_BN", "Hant");
        t.put("zh_GB", "Hant");
        t.put("zh_GF", "Hant");
        t.put("zh_HK", "Hant");
        t.put("zh_ID", "Hant");
        t.put("zh_MO", "Hant");
        t.put("zh_PA", "Hant");
        t.put("zh_PF", "Hant");
        t.put("zh_PH", "Hant");
        t.put("zh_SR", "Hant");
        t.put("zh_TH", "Hant");
        t.put("zh_TW", "Hant");
        t.put("zh_US", "Hant");
        t.put("zh_VN", "Hant");
        t.put("zhd", "Hani");
        t.put("zko", "Cyrl");
        t.put("zkt", "Kits");
        t.put("zkz", "Cyrl");
        t.put("zlj", "Hani");
        t.put("zln", "Hani");
        t.put("zlq", "Hani");
        t.put("zqe", "Hani");
        t.put("zrg", "Orya");
        t.put("zrp", "Hebr");
        t.put("zum", "Arab");
        t.put("zwa", "Ethi");
        t.put("zyg", "Hani");
        t.put("zyn", "Hani");
        t.put("zzj", "Hani");
        return Collections.unmodifiableMap(t);
    }

    private static Map<String, String> buildParentLocaleTable() {
        HashMap<String, String> t = new HashMap<String, String>();
        t.put("az_Arab", "root");
        t.put("az_Cyrl", "root");
        t.put("bal_Latn", "root");
        t.put("blt_Latn", "root");
        t.put("bm_Nkoo", "root");
        t.put("bs_Cyrl", "root");
        t.put("byn_Latn", "root");
        t.put("cu_Glag", "root");
        t.put("dje_Arab", "root");
        t.put("dyo_Arab", "root");
        t.put("en_150", "en_001");
        t.put("en_AG", "en_001");
        t.put("en_AI", "en_001");
        t.put("en_AT", "en_150");
        t.put("en_AU", "en_001");
        t.put("en_BB", "en_001");
        t.put("en_BE", "en_150");
        t.put("en_BM", "en_001");
        t.put("en_BS", "en_001");
        t.put("en_BW", "en_001");
        t.put("en_BZ", "en_001");
        t.put("en_CC", "en_001");
        t.put("en_CH", "en_150");
        t.put("en_CK", "en_001");
        t.put("en_CM", "en_001");
        t.put("en_CX", "en_001");
        t.put("en_CY", "en_001");
        t.put("en_CZ", "en_150");
        t.put("en_DE", "en_150");
        t.put("en_DG", "en_001");
        t.put("en_DK", "en_150");
        t.put("en_DM", "en_001");
        t.put("en_Dsrt", "root");
        t.put("en_EE", "en_150");
        t.put("en_ER", "en_001");
        t.put("en_ES", "en_150");
        t.put("en_FI", "en_150");
        t.put("en_FJ", "en_001");
        t.put("en_FK", "en_001");
        t.put("en_FM", "en_001");
        t.put("en_FR", "en_150");
        t.put("en_GB", "en_001");
        t.put("en_GD", "en_001");
        t.put("en_GE", "en_150");
        t.put("en_GG", "en_001");
        t.put("en_GH", "en_001");
        t.put("en_GI", "en_001");
        t.put("en_GM", "en_001");
        t.put("en_GS", "en_001");
        t.put("en_GY", "en_001");
        t.put("en_HK", "en_001");
        t.put("en_HU", "en_150");
        t.put("en_ID", "en_001");
        t.put("en_IE", "en_001");
        t.put("en_IL", "en_001");
        t.put("en_IM", "en_001");
        t.put("en_IN", "en_001");
        t.put("en_IO", "en_001");
        t.put("en_IT", "en_150");
        t.put("en_JE", "en_001");
        t.put("en_JM", "en_001");
        t.put("en_KE", "en_001");
        t.put("en_KI", "en_001");
        t.put("en_KN", "en_001");
        t.put("en_KY", "en_001");
        t.put("en_LC", "en_001");
        t.put("en_LR", "en_001");
        t.put("en_LS", "en_001");
        t.put("en_LT", "en_150");
        t.put("en_LV", "en_150");
        t.put("en_MG", "en_001");
        t.put("en_MO", "en_001");
        t.put("en_MS", "en_001");
        t.put("en_MT", "en_001");
        t.put("en_MU", "en_001");
        t.put("en_MV", "en_001");
        t.put("en_MW", "en_001");
        t.put("en_MY", "en_001");
        t.put("en_NA", "en_001");
        t.put("en_NF", "en_001");
        t.put("en_NG", "en_001");
        t.put("en_NL", "en_150");
        t.put("en_NO", "en_150");
        t.put("en_NR", "en_001");
        t.put("en_NU", "en_001");
        t.put("en_NZ", "en_001");
        t.put("en_PG", "en_001");
        t.put("en_PK", "en_001");
        t.put("en_PL", "en_150");
        t.put("en_PN", "en_001");
        t.put("en_PT", "en_150");
        t.put("en_PW", "en_001");
        t.put("en_RO", "en_150");
        t.put("en_RW", "en_001");
        t.put("en_SB", "en_001");
        t.put("en_SC", "en_001");
        t.put("en_SD", "en_001");
        t.put("en_SE", "en_150");
        t.put("en_SG", "en_001");
        t.put("en_SH", "en_001");
        t.put("en_SI", "en_150");
        t.put("en_SK", "en_150");
        t.put("en_SL", "en_001");
        t.put("en_SS", "en_001");
        t.put("en_SX", "en_001");
        t.put("en_SZ", "en_001");
        t.put("en_Shaw", "root");
        t.put("en_TC", "en_001");
        t.put("en_TK", "en_001");
        t.put("en_TO", "en_001");
        t.put("en_TT", "en_001");
        t.put("en_TV", "en_001");
        t.put("en_TZ", "en_001");
        t.put("en_UA", "en_150");
        t.put("en_UG", "en_001");
        t.put("en_VC", "en_001");
        t.put("en_VG", "en_001");
        t.put("en_VU", "en_001");
        t.put("en_WS", "en_001");
        t.put("en_ZA", "en_001");
        t.put("en_ZM", "en_001");
        t.put("en_ZW", "en_001");
        t.put("es_AR", "es_419");
        t.put("es_BO", "es_419");
        t.put("es_BR", "es_419");
        t.put("es_BZ", "es_419");
        t.put("es_CL", "es_419");
        t.put("es_CO", "es_419");
        t.put("es_CR", "es_419");
        t.put("es_CU", "es_419");
        t.put("es_DO", "es_419");
        t.put("es_EC", "es_419");
        t.put("es_GT", "es_419");
        t.put("es_HN", "es_419");
        t.put("es_JP", "es_419");
        t.put("es_MX", "es_419");
        t.put("es_NI", "es_419");
        t.put("es_PA", "es_419");
        t.put("es_PE", "es_419");
        t.put("es_PR", "es_419");
        t.put("es_PY", "es_419");
        t.put("es_SV", "es_419");
        t.put("es_US", "es_419");
        t.put("es_UY", "es_419");
        t.put("es_VE", "es_419");
        t.put("ff_Adlm", "root");
        t.put("ff_Arab", "root");
        t.put("ha_Arab", "root");
        t.put("hi_Latn", "en_IN");
        t.put("ht", "fr_HT");
        t.put("iu_Latn", "root");
        t.put("kaa_Latn", "root");
        t.put("kk_Arab", "root");
        t.put("kok_Latn", "root");
        t.put("ks_Deva", "root");
        t.put("ku_Arab", "root");
        t.put("kxv_Deva", "root");
        t.put("kxv_Orya", "root");
        t.put("kxv_Telu", "root");
        t.put("ky_Arab", "root");
        t.put("ky_Latn", "root");
        t.put("ml_Arab", "root");
        t.put("mn_Mong", "root");
        t.put("mni_Mtei", "root");
        t.put("ms_Arab", "root");
        t.put("nb", "no");
        t.put("nn", "no");
        t.put("no_NO", "no");
        t.put("pa_Arab", "root");
        t.put("pt_AO", "pt_PT");
        t.put("pt_CH", "pt_PT");
        t.put("pt_CV", "pt_PT");
        t.put("pt_FR", "pt_PT");
        t.put("pt_GQ", "pt_PT");
        t.put("pt_GW", "pt_PT");
        t.put("pt_LU", "pt_PT");
        t.put("pt_MO", "pt_PT");
        t.put("pt_MZ", "pt_PT");
        t.put("pt_ST", "pt_PT");
        t.put("pt_TL", "pt_PT");
        t.put("sat_Deva", "root");
        t.put("sd_Deva", "root");
        t.put("sd_Khoj", "root");
        t.put("sd_Sind", "root");
        t.put("shi_Latn", "root");
        t.put("so_Arab", "root");
        t.put("sr_Latn", "root");
        t.put("suz_Sunu", "root");
        t.put("sw_Arab", "root");
        t.put("tg_Arab", "root");
        t.put("ug_Cyrl", "root");
        t.put("uz_Arab", "root");
        t.put("uz_Cyrl", "root");
        t.put("vai_Latn", "root");
        t.put("wo_Arab", "root");
        t.put("yo_Arab", "root");
        t.put("yue_Hans", "root");
        t.put("zh_Hant", "root");
        t.put("zh_Hant_MO", "zh_Hant_HK");
        return Collections.unmodifiableMap(t);
    }
}

