/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.util.StringUtils;
import org.osgi.service.prefs.BackingStoreException;

public class EGitFilePasswordProvider
extends IdentityPasswordProvider {
    private boolean useSecureStore;

    public EGitFilePasswordProvider(CredentialsProvider provider) {
        super(provider);
    }

    protected char[] getPassword(URIish uri, int attempt, @NonNull IdentityPasswordProvider.State state) throws IOException {
        if (attempt == 0) {
            this.useSecureStore = Platform.getPreferencesService().getBoolean("org.eclipse.egit.core", "core_save_credentials_in_secure_store", true, null);
            if (this.useSecureStore) {
                try {
                    String password;
                    UserPasswordCredentials credentials = Activator.getDefault().getCredentialsStore().getCredentials(uri);
                    if (credentials != null && (password = credentials.getPassword()) != null) {
                        char[] pass = password.toCharArray();
                        state.setPassword(pass);
                        return pass;
                    }
                }
                catch (StorageException e) {
                    if (e.getErrorCode() == 4) {
                        this.useSecureStore = false;
                        this.savePrefs();
                    } else {
                        Activator.logError(e.getMessage(), e);
                    }
                }
                catch (RuntimeException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
        return super.getPassword(uri, attempt, state);
    }

    protected char[] getPassword(URIish uri, String message) {
        CredentialsProvider provider = this.getCredentialsProvider();
        if (provider == null) {
            return null;
        }
        boolean haveMessage = !StringUtils.isEmptyOrNull((String)message);
        ArrayList<Object> items = new ArrayList<Object>(haveMessage ? 3 : 2);
        if (haveMessage) {
            items.add(new CredentialItem.InformationalMessage(message));
        }
        CredentialItem.Password password = new CredentialItem.Password(CoreText.EGitSshdSessionFactory_sshKeyEncryptedPrompt);
        items.add(password);
        CredentialItem.YesNoType storeValue = new CredentialItem.YesNoType(CoreText.EGitSshdSessionFactory_sshKeyPassphraseStorePrompt);
        storeValue.setValue(this.useSecureStore);
        items.add(storeValue);
        try {
            char[] pass;
            boolean shouldStore;
            if (!provider.get(uri, items)) {
                this.cancelAuthentication();
            }
            if (this.useSecureStore != (shouldStore = storeValue.getValue())) {
                this.useSecureStore = shouldStore;
                this.savePrefs();
            }
            char[] cArray = (pass = password.getValue()) == null ? null : (char[])pass.clone();
            return cArray;
        }
        finally {
            password.clear();
        }
    }

    protected boolean keyLoaded(URIish uri, IdentityPasswordProvider.State state, char[] password, Exception err) throws IOException, GeneralSecurityException {
        if (state != null && password != null) {
            if (state.getCount() == 0) {
                if (err != null) {
                    try {
                        Activator.getDefault().getCredentialsStore().clearCredentials(uri);
                    }
                    catch (IOException | RuntimeException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                    return true;
                }
            } else if (err == null && this.useSecureStore) {
                UserPasswordCredentials credentials = new UserPasswordCredentials("egit:ssh:resource", new String(password));
                try {
                    Activator.getDefault().getCredentialsStore().putCredentials(uri, credentials);
                }
                catch (StorageException e) {
                    if (e.getErrorCode() == 4) {
                        this.useSecureStore = false;
                        this.savePrefs();
                    } else {
                        Activator.logError(e.getMessage(), e);
                    }
                }
                catch (RuntimeException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
        return super.keyLoaded(uri, state, password, err);
    }

    private void savePrefs() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        prefs.putBoolean("core_save_credentials_in_secure_store", this.useSecureStore);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(CoreText.EGitSshdSessionFactory_savingPreferencesFailed, e);
        }
    }
}

