/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.Locale;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalGpg;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

public class ExternalGpgSignatureVerifier
implements SignatureVerifier {
    private static final DateTimeFormatter GPG_DATE_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter(Locale.ROOT);
    private final boolean x509;

    public ExternalGpgSignatureVerifier() {
        this(false);
    }

    public ExternalGpgSignatureVerifier(boolean x509) {
        this.x509 = x509;
    }

    public SignatureVerifier.SignatureVerification verify(Repository repository, GpgConfig config, byte[] data, byte[] signatureData) throws IOException {
        String program = config.getProgram();
        if (StringUtils.isEmptyOrNull((String)program)) {
            String string = program = this.x509 ? ExternalGpg.getGpgSm() : ExternalGpg.getGpg();
            if (StringUtils.isEmptyOrNull((String)program)) {
                throw new IOException(CoreText.ExternalGpgSigner_gpgNotFound);
            }
        } else {
            program = ExternalGpg.findExecutable(program);
        }
        File signatureFile = null;
        SignatureVerifier.SignatureVerification[] verification = new SignatureVerifier.SignatureVerification[1];
        String[] name = new String[1];
        try {
            signatureFile = File.createTempFile("egit", ".sig");
            Files.write(signatureFile.toPath(), signatureData, new OpenOption[0]);
            ProcessBuilder process = new ProcessBuilder(new String[0]);
            process.command(program, "--status-fd", "1", "--verify", signatureFile.getAbsolutePath(), "-");
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (ByteArrayInputStream dataIn = new ByteArrayInputStream(data);){
                    ExternalProcessRunner.run(process, dataIn, b -> {
                        signatureVerificationArray[0] = this.fromGpg(b);
                    }, b -> {
                        stringArray[0] = this.extractProgramName(b);
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CanceledException canceledException) {}
        }
        finally {
            if (signatureFile != null && !signatureFile.delete()) {
                signatureFile.deleteOnExit();
            }
        }
        SignatureVerifier.SignatureVerification v = verification[0];
        if (v != null && name[0] != null && !name[0].equals(v.verifierName())) {
            return new SignatureVerifier.SignatureVerification(name[0], v.creationDate(), v.signer(), v.keyFingerprint(), v.keyUser(), v.verified(), v.expired(), v.trustLevel(), v.message());
        }
        return v;
    }

    private String extractProgramName(TemporaryBuffer buffer) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(buffer.openInputStream(), StandardCharsets.UTF_8));){
                int i;
                String line = r.readLine();
                if (line != null && (i = line.indexOf(": ")) > 0) {
                    return line.substring(0, i);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SignatureVerifier.SignatureVerification fromGpg(TemporaryBuffer buffer) {
        Date date;
        Instant createdAt = null;
        SignatureVerifier.TrustLevel trust = SignatureVerifier.TrustLevel.UNKNOWN;
        String fingerprint = null;
        boolean validates = false;
        boolean expired = false;
        String message = null;
        String keyId = null;
        String userId = null;
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(buffer.openInputStream(), StandardCharsets.UTF_8));){
                String line;
                block29: while ((line = r.readLine()) != null) {
                    if (!line.startsWith("[GNUPG:]")) continue;
                    if ((line = line.substring(8).trim()).startsWith("TRUST_")) {
                        String level;
                        int i = line.indexOf(32);
                        if (i < 0) {
                            i = line.length();
                        }
                        if ("FULLY".equals(level = line.substring(6, i))) {
                            trust = SignatureVerifier.TrustLevel.FULL;
                            continue;
                        }
                        try {
                            trust = SignatureVerifier.TrustLevel.valueOf((String)level);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue;
                    }
                    if (line.startsWith("SIG_ID")) {
                        String[] parts = line.split(" ");
                        if (parts.length <= 3) continue;
                        try {
                            createdAt = this.parseDate(parts[3].trim());
                        }
                        catch (RuntimeException level) {}
                        continue;
                    }
                    if (line.startsWith("VALIDSIG")) {
                        int i = line.indexOf(32);
                        int j = -1;
                        if (i > 0) {
                            j = line.indexOf(32, i + 1);
                        }
                        if (j > i) {
                            fingerprint = line.substring(i + 1, j);
                        }
                        if (createdAt != null || (i = line.indexOf(32, j + 1)) <= j) continue;
                        j = line.indexOf(32, i + 1);
                        String dateTime = line.substring(i + 1, j);
                        try {
                            createdAt = this.parseDate(dateTime);
                        }
                        catch (RuntimeException runtimeException) {}
                        continue;
                    }
                    int i = line.indexOf(32);
                    if (i < 0) {
                        i = line.length();
                    }
                    String key = line.substring(0, i);
                    boolean haveUserId = true;
                    switch (key) {
                        case "ERRSIG": {
                            haveUserId = false;
                            message = CoreText.ExternalGpgVerifier_erroneousSignature;
                            break;
                        }
                        case "GOODSIG": {
                            validates = true;
                            break;
                        }
                        case "BADSIG": {
                            message = CoreText.ExternalGpgVerifier_badSignature;
                            break;
                        }
                        case "EXPSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredSignature;
                            break;
                        }
                        case "EXPKEYSIG": {
                            expired = true;
                            message = CoreText.ExternalGpgVerifier_expiredKeySignature;
                            break;
                        }
                        case "REVKEYSIG": {
                            message = CoreText.ExternalGpgVerifier_revokedKeySignature;
                            break;
                        }
                        default: {
                            continue block29;
                        }
                    }
                    if (keyId != null) {
                        validates = false;
                        message = CoreText.ExternalGpgVerifier_multipleSignatures;
                        break;
                    }
                    int j = line.indexOf(32, i + 1);
                    if (j <= i) {
                        j = line.length();
                    }
                    keyId = line.substring(i + 1, j);
                    if (haveUserId && j < line.length()) {
                        userId = line.substring(j + 1);
                    }
                    if (message == null) continue;
                    message = MessageFormat.format(message, keyId, userId);
                }
                if (StringUtils.isEmptyOrNull(fingerprint)) {
                    fingerprint = keyId;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            message = MessageFormat.format(CoreText.ExternalGpgVerifier_failure, e.getLocalizedMessage());
            validates = false;
        }
        String string = this.getName();
        if (createdAt != null) {
            date = Date.from(createdAt);
            return new SignatureVerifier.SignatureVerification(string, date, userId, fingerprint, userId, validates, expired, trust, message);
        }
        date = null;
        return new SignatureVerifier.SignatureVerification(string, date, userId, fingerprint, userId, validates, expired, trust, message);
    }

    private Instant parseDate(String dateTime) {
        if (dateTime.indexOf(84) > 0) {
            return GPG_DATE_FORMAT.parse((CharSequence)dateTime, LocalDateTime::from).atOffset(ZoneOffset.UTC).toInstant();
        }
        return Instant.ofEpochSecond(Long.parseLong(dateTime));
    }

    public String getName() {
        return this.x509 ? "gpgsm" : "gpg";
    }

    public void clear() {
    }
}

