/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.core.services;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeServiceDescriptor;

public class SynchronizeServiceDescriptor
implements ISynchronizeServiceDescriptor {
    private final String fName;
    private final String fId;
    private ISynchronizeService fService;

    public SynchronizeServiceDescriptor(IConfigurationElement configElement) {
        this.fId = configElement.getAttribute("id");
        this.fName = configElement.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public ISynchronizeService getService() {
        if (this.fService == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.sync.core", "synchronizeService");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        String extensionId = configElement.getAttribute("id");
                        if (extensionId != null && extensionId.equals(this.fId)) {
                            try {
                                String serviceClass = configElement.getAttribute("class");
                                Class cls = Platform.getBundle((String)configElement.getDeclaringExtension().getContributor().getName()).loadClass(serviceClass);
                                Constructor cons = cls.getConstructor(ISynchronizeServiceDescriptor.class);
                                this.fService = (ISynchronizeService)cons.newInstance(this);
                                return this.fService;
                            }
                            catch (Exception e) {
                                String className = configElement.getAttribute("class");
                                RDTSyncCorePlugin.log(NLS.bind((String)Messages.SynchronizeServiceDescriptor_Invalid_class, (Object[])new String[]{className, this.fId}), e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            return null;
        }
        return this.fService;
    }
}

