/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.core.spi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

public abstract class AbstractConfigurationCache<C extends Serializable> {
    private final File cacheFile;
    private Map<String, C> configurationByUrl;

    public AbstractConfigurationCache(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    public AbstractConfigurationCache() {
        this(null);
    }

    protected abstract C createConfiguration();

    public void flush() {
        if (this.cacheFile == null || this.configurationByUrl == null) {
            return;
        }
    }

    public C getConfiguration(String url) {
        this.initialize();
        Serializable configuration = (Serializable)this.configurationByUrl.get(url);
        if (configuration == null) {
            configuration = this.createConfiguration();
            this.configurationByUrl.put(url, configuration);
        }
        return (C)configuration;
    }

    protected void initialize() {
        if (this.configurationByUrl == null) {
            this.configurationByUrl = new HashMap<String, C>();
            this.readCache();
        }
    }

    protected void readCache() {
        if (this.cacheFile == null || !this.cacheFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.cacheFile));){
                int size = in.readInt();
                int i = 0;
                while (i < size) {
                    String url = (String)in.readObject();
                    C data = this.readConfiguration(in);
                    if (url != null && data != null) {
                        this.configurationByUrl.put(url, data);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.builds.core", "The configuration cache could not be read", e));
        }
    }

    protected abstract C readConfiguration(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public void setConfiguration(String url, C configuration) {
        this.initialize();
        this.configurationByUrl.put(url, configuration);
        this.writeCache();
    }

    protected void writeCache() {
        if (this.cacheFile == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheFile)));){
                out.writeInt(this.configurationByUrl.size());
                for (String url : this.configurationByUrl.keySet()) {
                    out.writeObject(url);
                    out.writeObject(this.configurationByUrl.get(url));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.builds.core", "The respository configuration cache could not be written", (Throwable)e));
        }
    }
}

