/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.AbstractDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.IDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.MarkerManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.PhantomManager;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;

public class DecoratorsManager
implements IDecoratorManager {
    private IDecoratorManager fPhantomManager;
    private IDecoratorManager fMarkerManager;

    public DecoratorsManager(EMFCompareConfiguration compareConfiguration, DiagramMergeViewer left, DiagramMergeViewer right, DiagramMergeViewer ancestor, ICompareColor color) {
        this.fPhantomManager = new PhantomManager(compareConfiguration, left, right, ancestor, color);
        this.fMarkerManager = new MarkerManager(compareConfiguration, left, right, ancestor, color);
    }

    @Override
    public void hideDecorators(Diff difference) {
        this.fMarkerManager.hideDecorators(difference);
        this.fPhantomManager.hideDecorators(difference);
    }

    @Override
    public void revealDecorators(Diff difference) {
        this.fMarkerManager.revealDecorators(difference);
        this.fPhantomManager.revealDecorators(difference);
    }

    @Override
    public void hideAll() {
        this.fMarkerManager.hideAll();
        this.fPhantomManager.hideAll();
    }

    @Override
    public void removeDecorators(Diff difference) {
        this.fMarkerManager.removeDecorators(difference);
        this.fPhantomManager.removeDecorators(difference);
    }

    @Override
    public void removeAll() {
        this.fMarkerManager.removeAll();
        this.fPhantomManager.removeAll();
    }

    @Override
    public Collection<AbstractDecoratorManager.AbstractDecorator> getAllDecorators() {
        ArrayList<AbstractDecoratorManager.AbstractDecorator> decorators = new ArrayList<AbstractDecoratorManager.AbstractDecorator>();
        decorators.addAll(this.fMarkerManager.getAllDecorators());
        decorators.addAll(this.fPhantomManager.getAllDecorators());
        return decorators;
    }
}

