/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.chat;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.chat.ChatMessage;

public class ChatRenderer
implements UnaryOperator<String> {
    public static final DateTimeFormatter WEEKDAY_FORMATTER = DateTimeFormatter.ofPattern("EEEE");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
    private static final String YESTERDAY = OM.BUNDLE.getTranslationSupport().getString("chat.yesterday");
    private static final String TODAY = OM.BUNDLE.getTranslationSupport().getString("chat.today");
    private static final String AVATAR_GENERATOR = "generator";
    private static final String NBSP = "&nbsp;";
    private static final String MESSAGES = "${MESSAGES}";
    private static final int MESSAGES_LENGTH = "${MESSAGES}".length();
    private static final boolean ALWAYS_LOAD_HTML_TEMPLATE = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.ui.chat.ChatRenderer.ALWAYS_LOAD_HTML_TEMPLATE");
    private Pair<String, String> htmlEnclosure;

    public String renderHTML(Iterable<Renderable> renderables, Map<String, Object> properties) {
        return ChatRenderer.build(html -> this.renderHTML(renderables, (StringBuilder)html, properties));
    }

    public void renderHTML(Iterable<Renderable> renderables, StringBuilder html, Map<String, Object> properties) {
        Pair<String, String> htmlEnclosure = this.getHTMLEnclosure(properties);
        html.append((String)htmlEnclosure.getElement1());
        html.append("\n<table width=\"100%\">\n");
        for (Renderable renderable : renderables) {
            html.append("<tr><td>");
            renderable.renderHTML(this, html, properties);
            html.append("</td></tr>");
        }
        html.append("</table width=\"100%\">\n");
        html.append((String)htmlEnclosure.getElement2());
    }

    public void renderHTML(DateLine dateLine, StringBuilder html, Map<String, Object> properties) {
        LocalDate date = dateLine.getDate();
        String dateString = this.getDateString(date, properties);
        dateString = this.getNonBreakableString(dateString);
        html.append("<table class=\"date-line\"><tr><td><hr></td><td class=\"date\">&nbsp;");
        html.append(dateString);
        html.append("&nbsp;</td><td><hr></td></tr></table>\n");
    }

    public void renderHTML(ChatMessage.Author author, StringBuilder html, Map<String, Object> properties) {
        URI avatar = author.getAvatar();
        if (avatar == null) {
            avatar = this.getAvatar(author, properties);
        }
        if (avatar != null) {
            String scheme = avatar.getScheme();
            if (AVATAR_GENERATOR.equals(scheme)) {
                AvatarGenerator generator;
                String type = avatar.getAuthority();
                String description = StringUtil.safe((String)avatar.getPath());
                if (description.length() > 0 && description.charAt(0) == '/') {
                    description = description.substring(1);
                }
                if ((generator = (AvatarGenerator)IPluginContainer.INSTANCE.getElementOrNull("org.eclipse.net4j.util.ui.avatarGenerators", type, description)) != null) {
                    generator.generateAvatar(author, html, properties);
                    return;
                }
            } else {
                html.append("<img class=\"avatar\" src=\"");
                html.append(avatar);
                html.append("\"");
                ChatRenderer.appendToolTip(author, html);
                html.append(">");
                return;
            }
        }
        html.append(NBSP);
    }

    public void renderHTML(BubbleGroup bubbleGroup, StringBuilder html, Map<String, Object> properties) {
        ChatMessage.Author author;
        boolean own = bubbleGroup.isOwn();
        LinkedList<Bubble> bubbles = bubbleGroup.getBubbles();
        html.append("<table class=\"container");
        if (own) {
            html.append("-own");
        }
        html.append("\"");
        if (own) {
            html.append(" align=\"right\"");
        } else {
            html.append(" align=\"left\"");
        }
        html.append("><tr><td class=\"avatar-column\" rowspan=\"");
        html.append(1 + bubbles.size());
        html.append("\">");
        if (own) {
            html.append(NBSP);
        } else {
            author = bubbleGroup.getAuthor();
            this.renderHTML(author, html, properties);
        }
        html.append("</td><td><div class=\"info\">");
        if (!own) {
            author = bubbleGroup.getAuthor();
            String name = author.getShortName();
            if (StringUtil.isEmpty((String)name)) {
                name = StringUtil.cap((String)author.getUserID());
            }
            html.append(name);
            html.append(", ");
        }
        LocalTime time = bubbleGroup.getFirstBubbleTime();
        html.append(time.format(TIME_FORMATTER));
        html.append("</div></td></tr>");
        for (Bubble bubbleRenderable : bubbles) {
            html.append("<tr><td class=\"pl\">");
            bubbleRenderable.renderHTML(this, html, properties);
            html.append("</td></tr>");
        }
        html.append("</table>\n");
    }

    public void renderHTML(Bubble bubble, StringBuilder html, Map<String, Object> properties) {
        BubbleGroup group = bubble.getGroup();
        boolean own = group.isOwn();
        html.append("<div class=\"bubble");
        if (own) {
            html.append("-own");
        }
        if (bubble.isLast()) {
            html.append(" bubble-last");
            if (own) {
                html.append("-own");
            }
        }
        html.append("\">");
        this.renderHTML(bubble.getText(), html, properties);
        html.append("</div>");
    }

    public void renderHTML(String markup, StringBuilder html, Map<String, Object> properties) {
        html.append("<p>");
        html.append(markup);
        html.append("</p>");
    }

    public String renderHTML(String markup, Map<String, Object> properties) {
        return ChatRenderer.build(html -> this.renderHTML(markup, (StringBuilder)html, properties));
    }

    @Override
    public String apply(String markup) {
        return ChatRenderer.build(html -> {
            html.append("<html><head><style>* { padding: 0; margin: 0; border: 0; }</style></html><body>\n");
            this.renderHTML(markup, (StringBuilder)html, null);
            html.append("\n</body></html>");
        });
    }

    public String stripMarkup(String markup) {
        String html = this.renderHTML(markup, null);
        return StringUtil.stripHTML((String)html);
    }

    public String getDateString(LocalDate date, Map<String, Object> properties) {
        LocalDate today = LocalDate.now();
        if (today.equals(date)) {
            return TODAY;
        }
        if (today.minusDays(1L).equals(date)) {
            return YESTERDAY;
        }
        return date.format(WEEKDAY_FORMATTER) + ", " + date.format(DATE_FORMATTER);
    }

    public String getNonBreakableString(String str) {
        return str.replace(" ", NBSP);
    }

    public URI getAvatar(ChatMessage.Author author, Map<String, Object> properties) {
        int colorClassID = Math.abs(author.getUserID().hashCode()) % 4 + 1;
        return URI.create("generator://default/gen" + colorClassID);
    }

    protected Pair<String, String> getHTMLEnclosure(Map<String, Object> properties) {
        if (this.htmlEnclosure == null || ALWAYS_LOAD_HTML_TEMPLATE) {
            String htmlTemplate = this.loadHTMLTemplate();
            int htmlMessagesPos = htmlTemplate.indexOf(MESSAGES);
            this.htmlEnclosure = Pair.create((Object)htmlTemplate.substring(0, htmlMessagesPos), (Object)htmlTemplate.substring(htmlMessagesPos + MESSAGES_LENGTH));
        }
        return this.htmlEnclosure;
    }

    protected String loadHTMLTemplate() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = OM.BUNDLE.getInputStream("html/chat.html");){
                return IOUtil.readText((Reader)new InputStreamReader(in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private static String build(Consumer<StringBuilder> htmlConsumer) {
        StringBuilder html = new StringBuilder();
        htmlConsumer.accept(html);
        return html.toString();
    }

    private static void appendToolTip(ChatMessage.Author author, StringBuilder html) {
        String fullName = author.getFullName();
        if (!StringUtil.isEmpty((String)fullName)) {
            html.append(" title=\"");
            html.append(fullName);
            html.append("\"");
        }
    }

    public static interface AvatarGenerator {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.ui.avatarGenerators";

        public void generateAvatar(ChatMessage.Author var1, StringBuilder var2, Map<String, Object> var3);

        public static final class Default
        implements AvatarGenerator {
            private final String colorClass;

            public Default(String colorClass) {
                this.colorClass = colorClass;
            }

            @Override
            public void generateAvatar(ChatMessage.Author author, StringBuilder html, Map<String, Object> properties) {
                html.append("<div class=\"avatar ");
                html.append(this.colorClass);
                html.append("\"");
                ChatRenderer.appendToolTip(author, html);
                html.append("><p>");
                html.append(author.getInitials());
                html.append("</p></div>");
            }

            public String toString() {
                return "AvatarGenerator[default, " + this.colorClass + "]";
            }

            public static class Factory
            extends org.eclipse.net4j.util.factory.Factory {
                public static final String TYPE = "default";

                public Factory() {
                    super(AvatarGenerator.PRODUCT_GROUP, TYPE);
                }

                public AvatarGenerator create(String description) throws ProductCreationException {
                    return new Default(description);
                }
            }
        }
    }

    public static final class Bubble
    extends Renderable {
        private final BubbleGroup group;
        private final LocalTime time;
        private final String text;

        private Bubble(BubbleGroup group, LocalTime time, String text) {
            this.group = group;
            this.time = time;
            this.text = text;
        }

        public BubbleGroup getGroup() {
            return this.group;
        }

        public LocalTime getTime() {
            return this.time;
        }

        public String getText() {
            return this.text;
        }

        public boolean isFirst() {
            return this.group.bubbles.getFirst() == this;
        }

        public boolean isLast() {
            return this.group.bubbles.getLast() == this;
        }

        @Override
        protected void renderHTML(ChatRenderer renderer, StringBuilder html, Map<String, Object> properties) {
            renderer.renderHTML(this, html, properties);
        }
    }

    public static final class BubbleGroup
    extends Renderable {
        private final ChatMessage.Author author;
        private final boolean own;
        private final LinkedList<Bubble> bubbles = new LinkedList<Bubble>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Bubble getFirst() {
                return this.isEmpty() ? null : (Bubble)super.getFirst();
            }

            @Override
            public Bubble getLast() {
                return this.isEmpty() ? null : (Bubble)super.getLast();
            }
        };

        BubbleGroup(ChatMessage.Author author, boolean own) {
            this.author = author;
            this.own = own;
        }

        public ChatMessage.Author getAuthor() {
            return this.author;
        }

        public boolean isOwn() {
            return this.own;
        }

        public LinkedList<Bubble> getBubbles() {
            return this.bubbles;
        }

        public LocalTime getFirstBubbleTime() {
            Bubble bubble = this.bubbles.getFirst();
            return bubble == null ? null : bubble.getTime();
        }

        public LocalTime getLastBubbleTime() {
            Bubble bubble = this.bubbles.getLast();
            return bubble == null ? null : bubble.getTime();
        }

        public Bubble addBubble(LocalTime time, String text) {
            Bubble bubble = new Bubble(this, time, text);
            this.bubbles.add(bubble);
            return bubble;
        }

        @Override
        protected void renderHTML(ChatRenderer renderer, StringBuilder html, Map<String, Object> properties) {
            renderer.renderHTML(this, html, properties);
        }
    }

    public static final class DateLine
    extends Renderable {
        private final LocalDate date;

        DateLine(LocalDate date) {
            this.date = date;
        }

        public final LocalDate getDate() {
            return this.date;
        }

        @Override
        protected void renderHTML(ChatRenderer renderer, StringBuilder html, Map<String, Object> properties) {
            renderer.renderHTML(this, html, properties);
        }
    }

    public static class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.net4j.util.ui.chatRenderers";
        public static final String DEFAULT_TYPE = "default";

        protected Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public Factory() {
            this(DEFAULT_TYPE);
        }

        public ChatRenderer create(String description) throws ProductCreationException {
            return new ChatRenderer();
        }
    }

    public static abstract class Renderable {
        private Renderable() {
        }

        protected abstract void renderHTML(ChatRenderer var1, StringBuilder var2, Map<String, Object> var3);
    }
}

