/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.admin.protocol;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientImpl;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientRepositoryImpl;
import org.eclipse.emf.cdo.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.internal.admin.protocol.CDOAdminClientProtocol;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryRepositoriesRequest
extends RequestWithConfirmation<Set<CDOAdminClientRepository>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryRepositoriesRequest.class);

    public QueryRepositoriesRequest(CDOAdminClientProtocol protocol) {
        super((SignalProtocol)protocol, (short)1);
    }

    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        out.writeBoolean(true);
    }

    protected Set<CDOAdminClientRepository> confirming(ExtendedDataInputStream in) throws Exception {
        CDOAdminClientProtocol protocol = (CDOAdminClientProtocol)this.getProtocol();
        CDOAdminClientImpl admin = (CDOAdminClientImpl)protocol.getInfraStructure();
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} repository infos...", new Object[]{size});
        }
        HashSet<CDOAdminClientRepository> result = new HashSet<CDOAdminClientRepository>();
        int i = 0;
        while (i < size) {
            CDOAdminClientRepositoryImpl repository = new CDOAdminClientRepositoryImpl(admin, in);
            result.add(repository);
            if (TRACER.isEnabled()) {
                TRACER.format("Read repository info for {0}", new Object[]{repository.getName()});
            }
            ++i;
        }
        return result;
    }
}

