/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.CreationUtil;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class ContainerCreationEditPolicy
extends SiriusContainerEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        if (!(this.getHost().getModel() instanceof View)) {
            return null;
        }
        EObject containerElement = ((View)this.getHost().getModel()).getElement();
        AbstractToolDescription tool = this.getTool(request);
        Command result = null;
        if (tool != null) {
            if (containerElement instanceof DDiagram) {
                DDiagram diagram = (DDiagram)containerElement;
                if (tool instanceof NodeCreationDescription) {
                    result = this.getCreateNodeOnDiagramCommand(request, (NodeCreationDescription)tool, diagram);
                } else if (tool instanceof ContainerCreationDescription) {
                    result = this.getCreateContainerOnDiagramCommand(request, (ContainerCreationDescription)tool, diagram);
                }
            } else if (containerElement instanceof DNodeContainer) {
                DNodeContainer nodeContainer = (DNodeContainer)containerElement;
                if (tool instanceof ContainerCreationDescription) {
                    result = this.getCreateContainerOnContainerCommand(request, (ContainerCreationDescription)tool, nodeContainer);
                }
            }
        }
        return result;
    }

    protected Command getCreateContainerOnContainerCommand(CreateRequest request, ContainerCreationDescription ccdTool, DNodeContainer nodeContainer) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)nodeContainer);
        IDiagramCommandFactory diagramCommandFactory = this.getDiagramCommandFactory(transactionalEditingDomain);
        CreationUtil creationUtil = new CreationUtil(request, diagramCommandFactory, this.getRealLocation(request), this.getHost());
        return creationUtil.getContainerCreationDescription((DDiagramElementContainer)nodeContainer, ccdTool);
    }

    protected Command getCreateContainerOnDiagramCommand(CreateRequest request, ContainerCreationDescription ccdTool, DDiagram diagram) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        IDiagramCommandFactory diagramCommandFactory = this.getDiagramCommandFactory(transactionalEditingDomain);
        CreationUtil creationUtil = new CreationUtil(request, diagramCommandFactory, this.getRealLocation(request), this.getHost());
        return creationUtil.getContainerCreationDescription(diagram, ccdTool);
    }

    protected Command getCreateNodeOnDiagramCommand(CreateRequest request, NodeCreationDescription ncdTool, DDiagram diagram) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        IDiagramCommandFactory diagramCommandFactory = this.getDiagramCommandFactory(transactionalEditingDomain);
        CreationUtil creationUtil = new CreationUtil(request, diagramCommandFactory, this.getRealLocation(request), this.getHost());
        return creationUtil.getNodeCreationCommand(diagram, ncdTool);
    }

    protected AbstractToolDescription getTool(CreateRequest request) {
        if (request.getNewObject() instanceof AbstractToolDescription) {
            return (AbstractToolDescription)request.getNewObject();
        }
        return null;
    }

    protected Point getRealLocation(CreateRequest request) {
        Point location = request.getLocation().getCopy();
        if (location != null && this.getHost() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.getHost()).getFigure().translateToRelative((Translatable)location);
        }
        return location;
    }

    private IDiagramCommandFactory getDiagramCommandFactory(TransactionalEditingDomain transactionalEditingDomain) {
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        return diagramCommandFactory;
    }
}

