/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.formatting;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.gef.dot.internal.language.DotHtmlLabelStandaloneSetup;
import org.eclipse.gef.dot.internal.language.formatting.DotFormatter;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.formatting.INodeModelStreamer;
import org.eclipse.xtext.formatting.impl.NodeModelStreamer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;

public class DotNodeModelStreamer
extends NodeModelStreamer {
    protected void writeSemantic(ITokenStream out, ICompositeNode node) throws IOException {
        AbstractRule rule = this.tokenUtil.getTokenRule((INode)node);
        Object val = this.valueConverter.toValue(this.tokenUtil.serializeNode((INode)node), rule.getName(), (INode)node);
        if (val instanceof ID && ((ID)val).getType() == ID.Type.HTML_STRING) {
            this.writeHTMLStringSemantic(rule, (DotFormatter.DotFormattingConfigBasedStream)out, node);
        } else {
            super.writeSemantic(out, node);
        }
    }

    private void writeHTMLStringSemantic(AbstractRule rule, DotFormatter.DotFormattingConfigBasedStream out, ICompositeNode node) throws IOException {
        Injector htmlLabelInjector = new DotHtmlLabelStandaloneSetup().createInjectorAndDoEMFRegistration();
        IFormatter dotHtmlLabelFormatter = (IFormatter)htmlLabelInjector.getInstance(IFormatter.class);
        TokenStringBuffer htmlLabelOut = new TokenStringBuffer();
        ITokenStream fmt = dotHtmlLabelFormatter.createFormatterStream("\t\t", (ITokenStream)htmlLabelOut, false);
        INodeModelStreamer dothtmlLabelNodeModelStreamer = (INodeModelStreamer)htmlLabelInjector.getInstance(INodeModelStreamer.class);
        IParser dotHtmlLabelParser = (IParser)htmlLabelInjector.getInstance(IParser.class);
        String trimmedNodeText = node.getText().trim();
        String htmlLabelText = trimmedNodeText.substring(1, trimmedNodeText.length() - 1);
        IParseResult parseResult = dotHtmlLabelParser.parse((Reader)new StringReader(htmlLabelText));
        ICompositeNode htmlLabelRootNode = parseResult.getRootNode();
        dothtmlLabelNodeModelStreamer.feedTokenStream(fmt, htmlLabelRootNode, 0, htmlLabelText.length());
        out.writeSemantic(null, "<");
        out.addNewLine();
        out.addLineEntry(node.getGrammarElement(), htmlLabelOut.toString(), false);
        out.addNewLine();
        out.writeSemantic(null, ">");
    }
}

