/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.view.core.ITerminalService;
import org.eclipse.terminal.view.ui.internal.TraceHandler;
import org.eclipse.terminal.view.ui.internal.listeners.WorkbenchWindowListener;
import org.eclipse.terminal.view.ui.internal.view.TerminalsView;
import org.eclipse.terminal.view.ui.internal.view.TerminalsViewMementoHandler;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegateManager;
import org.eclipse.terminal.view.ui.launcher.ITerminalConsoleViewManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class UIPlugin
extends AbstractUIPlugin {
    private static volatile UIPlugin plugin;
    private static volatile ScopedPreferenceStore scopedPreferences;
    private static volatile TraceHandler traceHandler;
    private IWorkbenchListener listener;
    private IWindowListener windowListener;
    private ServiceTracker<ITerminalService, ITerminalService> terminalServiceTracker;
    private ServiceTracker<ILauncherDelegateManager, ILauncherDelegateManager> launchDelegateServiceTracker;
    private ServiceTracker<ITerminalConsoleViewManager, ITerminalConsoleViewManager> consoleManagerTracker;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.terminal.view.ui";
    }

    public static ScopedPreferenceStore getScopedPreferences() {
        if (scopedPreferences == null) {
            scopedPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, UIPlugin.getUniqueIdentifier());
        }
        return scopedPreferences;
    }

    public static TraceHandler getTraceHandler() {
        if (traceHandler == null) {
            traceHandler = new TraceHandler(UIPlugin.getUniqueIdentifier());
        }
        return traceHandler;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.terminalServiceTracker = new ServiceTracker(context, ITerminalService.class, null);
        this.terminalServiceTracker.open();
        this.launchDelegateServiceTracker = new ServiceTracker(context, ILauncherDelegateManager.class, null);
        this.launchDelegateServiceTracker.open();
        this.consoleManagerTracker = new ServiceTracker(context, ITerminalConsoleViewManager.class, null);
        this.consoleManagerTracker.open();
        plugin = this;
        this.listener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                if (workbench != null && workbench.getActiveWorkbenchWindow() != null && workbench.getActiveWorkbenchWindow().getActivePage() != null) {
                    IViewReference[] refs;
                    IViewReference[] iViewReferenceArray = refs = workbench.getActiveWorkbenchWindow().getActivePage().getViewReferences();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference ref = iViewReferenceArray[n2];
                        IViewPart part = ref.getView(false);
                        if (part instanceof TerminalsView) {
                            TerminalsViewMementoHandler mementoHandler;
                            ArrayList<CTabItem> saveables = new ArrayList<CTabItem>();
                            CTabFolder tabFolder = ((TerminalsView)part).getAdapter(CTabFolder.class);
                            if (tabFolder != null && !tabFolder.isDisposed()) {
                                CTabItem[] items;
                                CTabItem[] cTabItemArray = items = tabFolder.getItems();
                                int n3 = items.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITerminalViewControl terminal;
                                    CTabItem item = cTabItemArray[n4];
                                    if (!item.isDisposed() && (terminal = (ITerminalViewControl)item.getData()) != null && terminal.getState() == TerminalState.CONNECTED) {
                                        saveables.add(item);
                                    }
                                    ++n4;
                                }
                            }
                            if ((mementoHandler = ((TerminalsView)part).getAdapter(TerminalsViewMementoHandler.class)) != null) {
                                mementoHandler.setSaveables(saveables);
                            }
                        }
                        ++n2;
                    }
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.listener);
        if (this.windowListener == null && PlatformUI.getWorkbench() != null) {
            this.windowListener = new WorkbenchWindowListener();
            PlatformUI.getWorkbench().addWindowListener(this.windowListener);
            this.activateContexts();
        }
    }

    void activateContexts() {
        if (Display.getCurrent() != null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && this.windowListener != null) {
                this.windowListener.windowOpened(window);
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.activateContexts());
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.terminalServiceTracker.close();
        this.launchDelegateServiceTracker.close();
        this.consoleManagerTracker.close();
        if (this.windowListener != null && PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
            this.windowListener = null;
        }
        scopedPreferences = null;
        traceHandler = null;
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.listener);
            this.listener = null;
        }
        super.stop(context);
        plugin = null;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        Bundle bundle = this.getBundle();
        URL consoleViewIconUrl = bundle.getEntry("icons/eview16/console_view.svg");
        registry.put("TerminalsView", ImageDescriptor.createFromURL((URL)consoleViewIconUrl));
        this.putActionImages(registry, bundle, "lock_co.svg", "ScrollLockAction_enabled", "ScrollLockAction_disabled");
        this.putActionImages(registry, bundle, "command_input_field.svg", "ToggleCommandField_enabled", "ToggleCommandField_disabled");
        this.putActionImages(registry, bundle, "new_terminal_view.svg", "NewTerminalViewAction_enabled", "NewTerminalViewAction_disabled");
        this.putActionImages(registry, bundle, "clear_co.svg", "ImageElclClearAll", "ImageDlclClearAll");
    }

    private void putActionImages(ImageRegistry registry, Bundle bundle, String file, String ekey, String dkey) {
        URL url = bundle.getEntry("icons/elcl16/" + file);
        ImageDescriptor base = ImageDescriptor.createFromURL((URL)url);
        registry.put(ekey, base);
        registry.put(dkey, ImageDescriptor.createWithFlags((ImageDescriptor)base, (int)1));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static boolean isOptionEnabled(String strOption) {
        String strEnabled = Platform.getDebugOption((String)strOption);
        if (strEnabled == null) {
            return false;
        }
        return Boolean.parseBoolean(strEnabled);
    }

    public static ITerminalService getTerminalService() {
        UIPlugin plugin = UIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return (ITerminalService)plugin.terminalServiceTracker.getService();
    }

    public static synchronized ILauncherDelegateManager getLaunchDelegateManager() {
        UIPlugin plugin = UIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return (ILauncherDelegateManager)plugin.launchDelegateServiceTracker.getService();
    }

    public static synchronized ITerminalConsoleViewManager getConsoleManager() {
        UIPlugin plugin = UIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return (ITerminalConsoleViewManager)plugin.consoleManagerTracker.getService();
    }
}

