/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.product.LauncherSection;
import org.eclipse.pde.internal.ui.editor.validation.IValidatorMessageHandler;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class EditorUtilities {
    private static final int F_EXACT_IMAGE_SIZE = 0;
    private static final int F_MAX_IMAGE_SIZE = 1;
    private static final int F_ICO_IMAGE = 2;
    private static final int F_IMAGE_DEPTH = 3;

    private static ImageData[] getImageData(IValidatorMessageHandler validator, FormEntry provider, IProduct product) {
        String imagePath = provider.getText().getText();
        String message = null;
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream stream = EditorUtilities.getResourceStream(imagePath, product);){
                ImageData[] idata = new ImageLoader().load(stream);
                if (idata != null && idata.length > 0) {
                    return idata;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            message = PDEUIMessages.EditorUtilities_noImageData;
        }
        catch (SWTException e) {
            message = PDEUIMessages.EditorUtilities_pathNotValidImage;
        }
        catch (IOException | CoreException e) {
            message = PDEUIMessages.EditorUtilities_invalidFilePath;
        }
        validator.addMessage(message, 2);
        return null;
    }

    private static boolean containsEmptyField(FormEntry provider) {
        return provider.getText().getText().length() == 0;
    }

    private static boolean imageEntryInternalValidate(IValidatorMessageHandler validator, FormEntry provider, IProduct product, ValidationInfo info, int validationType) {
        if (EditorUtilities.containsEmptyField(provider)) {
            return true;
        }
        ImageData[] idata = EditorUtilities.getImageData(validator, provider, product);
        if (idata == null) {
            return false;
        }
        ValidationMessage ms = null;
        switch (validationType) {
            case 1: {
                ms = EditorUtilities.getMS_maxImageSize(idata[0], info.maxWidth, info.maxHeight, info.warningWidth, info.warningHeight);
                break;
            }
            case 2: {
                ms = EditorUtilities.getMS_icoImage(idata);
                break;
            }
            case 3: {
                ms = EditorUtilities.getMS_imageDepth(idata[0], info.requiredDepth);
            }
            case 0: {
                if (ms != null) break;
                ms = EditorUtilities.getMS_exactImageSize(idata[0], info.maxWidth, info.maxHeight);
            }
        }
        if (ms != null) {
            validator.addMessage(ms.fMessage, ms.fSeverity);
        }
        return ms == null;
    }

    public static boolean imageEntryHasValidIco(IValidatorMessageHandler validator, FormEntry provider, IProduct product) {
        ValidationInfo info = new ValidationInfo();
        return EditorUtilities.imageEntryInternalValidate(validator, provider, product, info, 2);
    }

    public static boolean imageEntrySizeDoesNotExceed(IValidatorMessageHandler validator, FormEntry provider, IProduct product, int mwidth, int mheight, int wwidth, int wheight) {
        ValidationInfo info = new ValidationInfo();
        info.maxWidth = mwidth;
        info.maxHeight = mheight;
        info.warningWidth = wwidth;
        info.warningHeight = wheight;
        return EditorUtilities.imageEntryInternalValidate(validator, provider, product, info, 1);
    }

    public static boolean imageEntryHasExactSize(IValidatorMessageHandler validator, FormEntry provider, IProduct product, int width, int height) {
        ValidationInfo info = new ValidationInfo();
        info.maxWidth = width;
        info.maxHeight = height;
        return EditorUtilities.imageEntryInternalValidate(validator, provider, product, info, 0);
    }

    public static boolean imageEntryHasExactDepthAndSize(IValidatorMessageHandler validator, FormEntry provider, IProduct product, int width, int height, int depth) {
        ValidationInfo info = new ValidationInfo();
        info.maxWidth = width;
        info.maxHeight = height;
        info.requiredDepth = depth;
        return EditorUtilities.imageEntryInternalValidate(validator, provider, product, info, 3);
    }

    private static ValidationMessage getMS_icoImage(ImageData[] imagedata) {
        int totalSizes = LauncherSection.F_WIN_ICON_DIMENSIONS.length;
        boolean[] found = new boolean[totalSizes];
        ImageData[] imageDataArray = imagedata;
        int n = imagedata.length;
        int n2 = 0;
        while (n2 < n) {
            ImageData data = imageDataArray[n2];
            int width = data.width;
            int height = data.height;
            int depth = data.depth;
            int w = 0;
            while (w < totalSizes) {
                if (width == LauncherSection.F_WIN_ICON_DIMENSIONS[w][0] && height == LauncherSection.F_WIN_ICON_DIMENSIONS[w][1] && depth == LauncherSection.F_WIN_ICON_DEPTHS[w]) {
                    found[w] = true;
                }
                ++w;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < found.length) {
            if (!found[i]) {
                if (sb.length() == 0) {
                    sb.append(PDEUIMessages.EditorUtilities_icoError);
                } else {
                    sb.append(", ");
                }
                int width = LauncherSection.F_WIN_ICON_DIMENSIONS[i][0];
                int height = LauncherSection.F_WIN_ICON_DIMENSIONS[i][1];
                int depth = LauncherSection.F_WIN_ICON_DEPTHS[i];
                sb.append(NLS.bind((String)PDEUIMessages.EditorUtilities_missingIcoNote, (Object)EditorUtilities.getSizeString(width, height), (Object)Integer.toString(depth)));
            }
            ++i;
        }
        if (sb.length() > 0) {
            return new ValidationMessage(sb.toString());
        }
        return null;
    }

    private static ValidationMessage getMS_exactImageSize(ImageData imagedata, int mwidth, int mheight) {
        int width = imagedata.width;
        int height = imagedata.height;
        if (width != mwidth || height != mheight) {
            return new ValidationMessage(NLS.bind((String)PDEUIMessages.EditorUtilities_incorrectSize, (Object)EditorUtilities.getSizeString(width, height)));
        }
        return null;
    }

    private static ValidationMessage getMS_maxImageSize(ImageData imagedata, int mwidth, int mheight, int wwidth, int wheight) {
        int width = imagedata.width;
        int height = imagedata.height;
        if (width > mwidth || height > mheight) {
            return new ValidationMessage(NLS.bind((String)PDEUIMessages.EditorUtilities_imageTooLarge, (Object)EditorUtilities.getSizeString(width, height)));
        }
        if (width > wwidth || height > wheight) {
            return new ValidationMessage(NLS.bind((String)PDEUIMessages.EditorUtilities_imageTooLargeInfo, (Object)EditorUtilities.getSizeString(wwidth, wheight)));
        }
        return null;
    }

    private static ValidationMessage getMS_imageDepth(ImageData imagedata, int depth) {
        if (imagedata.depth != depth) {
            return new ValidationMessage(NLS.bind((String)PDEUIMessages.EditorUtilities_incorrectImageDepth, (Object)Integer.toString(imagedata.depth)));
        }
        return null;
    }

    private static String getSizeString(int width, int height) {
        return width + " x " + height;
    }

    private static InputStream getResourceStream(String filePath, IProduct product) throws IOException, CoreException {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        if (filePath.indexOf(47) == 0) {
            IResource iResource = root.findMember(filePath);
            if (iResource instanceof IFile) {
                IFile file = (IFile)iResource;
                return file.getContents();
            }
            throw new IOException();
        }
        IProject project = product.getModel().getUnderlyingResource().getProject();
        IResource iResource = project.findMember(filePath);
        if (iResource instanceof IFile) {
            IFile file = (IFile)iResource;
            return file.getContents();
        }
        IPluginModelBase model = PluginRegistry.findModel((String)product.getDefiningPluginId());
        if (model != null && model.getInstallLocation() != null) {
            File modelNode = new File(model.getInstallLocation());
            if (modelNode.isFile() && CoreUtility.jarContainsResource((File)modelNode, (String)filePath, (boolean)false)) {
                URI jarURI = URIUtil.toJarURI((URI)modelNode.toURI(), (IPath)IPath.fromOSString((String)filePath));
                return jarURI.toURL().openStream();
            }
            return Files.newInputStream(modelNode.toPath().resolve(filePath), new OpenOption[0]);
        }
        throw new IOException();
    }

    private static IPath getRootPath(IPath path, String definingPluginId) {
        IPluginModelBase model = PluginRegistry.findModel((String)definingPluginId);
        if (model != null && model.getInstallLocation() != null) {
            IPath newPath = IPath.fromOSString((String)model.getInstallLocation()).append(path);
            IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
            IContainer container = root.getContainerForLocation(newPath);
            if (container != null) {
                return container.getFullPath();
            }
        }
        return path;
    }

    private static IResource getImageResource(String value, String definingPluginId) {
        if (value == null) {
            return null;
        }
        IPath path = IPath.fromOSString((String)value);
        if (path.isEmpty()) {
            return null;
        }
        if (!path.isAbsolute()) {
            path = EditorUtilities.getRootPath(path, definingPluginId);
        }
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        return root.findMember(path);
    }

    public static void openImage(String value, String definingPluginId) {
        IResource resource = EditorUtilities.getImageResource(value, definingPluginId);
        try {
            if (resource != null && resource instanceof IFile) {
                IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)((IFile)resource), (boolean)true);
            } else {
                MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.AboutSection_open, (String)PDEUIMessages.AboutSection_warning);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static void showInPackageExplorer(IPackageFragment fragment) {
        EditorUtilities.showPackageExplorer().map(p -> (IShowInTarget)p.getAdapter(IShowInTarget.class)).ifPresent(show -> {
            boolean bl = show.show(new ShowInContext(null, (ISelection)new StructuredSelection((Object)fragment)));
        });
    }

    private static Optional<IViewPart> showPackageExplorer() {
        try {
            return Optional.of(PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer"));
        }
        catch (PartInitException e) {
            return Optional.empty();
        }
    }

    static class ValidationInfo {
        int maxWidth;
        int maxHeight;
        int warningWidth;
        int warningHeight;
        int requiredDepth;

        ValidationInfo() {
        }
    }

    static class ValidationMessage {
        String fMessage;
        int fSeverity = 2;

        ValidationMessage(String message) {
            this.fMessage = message;
        }
    }
}

