/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableData2;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.ITableDataEditor;
import org.eclipse.ui.IActionFilter;

public class TableDataCell
implements IActionFilter {
    protected ITableDataEditor editor;
    protected Object row;
    protected int col;

    public TableDataCell(ITableDataEditor editor, Object row, int col) {
        this.editor = editor;
        this.row = row;
        this.col = col;
    }

    public int getCol() {
        return this.col;
    }

    public Object getRow() {
        return this.row;
    }

    public ITableDataEditor getEditor() {
        return this.editor;
    }

    public Object getValue() {
        if (this.row instanceof IRowData) {
            return ((IRowData)this.row).getValue(this.col);
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("vendor")) {
            Database db = this.editor.getSqlTable().getSchema().getCatalog() != null ? this.editor.getSqlTable().getSchema().getCatalog().getDatabase() : this.editor.getSqlTable().getSchema().getDatabase();
            String vendor = db.getVendor();
            return value.equals(vendor);
        }
        if (name.equals("version")) {
            Database db = this.editor.getSqlTable().getSchema().getCatalog() != null ? this.editor.getSqlTable().getSchema().getCatalog().getDatabase() : this.editor.getSqlTable().getSchema().getDatabase();
            String version = db.getVersion();
            return value.equals(version);
        }
        if (name.equals("dataType")) {
            Column sqlCol = null;
            sqlCol = this.editor.getTableData() instanceof ITableData2 ? (Column)((ITableData2)this.editor.getTableData()).getResultColumns().get(this.col) : (Column)this.editor.getSqlTable().getColumns().get(this.col);
            return value.equals(sqlCol.getDataType().getName());
        }
        if (name.equals("nullable")) {
            Column sqlCol = null;
            sqlCol = this.editor.getTableData() instanceof ITableData2 ? (Column)((ITableData2)this.editor.getTableData()).getResultColumns().get(this.col) : (Column)this.editor.getSqlTable().getColumns().get(this.col);
            return Boolean.valueOf(value).booleanValue() == sqlCol.isNullable();
        }
        if (name.equals("insertionCell")) {
            boolean b = this.row instanceof IRowData;
            return Boolean.valueOf(value) ^ b;
        }
        return false;
    }
}

