/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.DialogSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.PageCompareEditorInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;

public class ParticipantPageCompareEditorInput
extends PageCompareEditorInput {
    private final ISynchronizeParticipant participant;
    private final ISynchronizePageConfiguration pageConfiguration;
    private Image titleImage;
    private IPageBookViewPage page;
    private DialogSynchronizePageSite site;
    private IPropertyChangeListener listener;
    private Button rememberParticipantButton;

    public ParticipantPageCompareEditorInput(CompareConfiguration configuration, ISynchronizePageConfiguration pageConfiguration, ISynchronizeParticipant participant) {
        super(configuration);
        this.pageConfiguration = pageConfiguration;
        this.participant = participant;
        pageConfiguration.setRunnableContext((IRunnableContext)this);
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.setTitle(Utils.shortenText(100, this.participant.getName()));
        return this.participant;
    }

    public Image getTitleImage() {
        if (this.titleImage == null) {
            this.titleImage = this.participant.getImageDescriptor().createImage();
        }
        return this.titleImage;
    }

    @Override
    protected void handleDispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        if (this.page != null) {
            this.page.dispose();
        }
        if (this.site != null) {
            this.site.dispose();
        }
        this.pageConfiguration.removePropertyChangeListener(this.listener);
        super.handleDispose();
    }

    @Override
    protected IPage createPage(CompareViewerPane parent, IToolBarManager toolBarManager) {
        this.listener = event -> {
            if (event.getProperty().equals("org.eclipse.team.ui.P_PAGE_DESCRIPTION")) {
                this.updateDescription();
            }
        };
        this.pageConfiguration.addPropertyChangeListener(this.listener);
        this.updateDescription();
        this.page = this.participant.createPage(this.pageConfiguration);
        this.site = new DialogSynchronizePageSite(parent.getShell(), true);
        ((SynchronizePageConfiguration)this.pageConfiguration).setSite(this.site);
        this.site.createActionBars(toolBarManager);
        try {
            ((ISynchronizePage)this.page).init(this.pageConfiguration.getSite());
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.page.createControl((Composite)parent);
        this.page.setActionBars(this.site.getActionBars());
        toolBarManager.update(true);
        return this.page;
    }

    void updateDescription() {
        String description = (String)this.pageConfiguration.getProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION");
        if (description != null) {
            this.setPageDescription(description);
        }
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return ((ISynchronizePage)this.page).getViewer();
    }

    @Override
    protected ICompareInput asCompareInput(ISelection selection) {
        IStructuredSelection ss;
        ICompareInput compareInput = super.asCompareInput(selection);
        if (compareInput != null) {
            return compareInput;
        }
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object o = ss.getFirstElement();
            ISynchronizeParticipant iSynchronizeParticipant = this.participant;
            if (iSynchronizeParticipant instanceof ModelSynchronizeParticipant) {
                ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)iSynchronizeParticipant;
                return msp.asCompareInput(o);
            }
        }
        return null;
    }

    @Override
    protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
        monitor.beginTask(TeamUIMessages.SyncInfoCompareInput_3, 100);
        monitor.setTaskName(TeamUIMessages.SyncInfoCompareInput_3);
        try {
            try {
                this.checkForBufferChange(this.pageConfiguration.getSite().getShell(), input, false, monitor);
                if (input instanceof SyncInfoModelElement) {
                    SyncInfoModelElement node = (SyncInfoModelElement)input;
                    IResource resource = node.getResource();
                    if (resource != null && resource.getType() == 1) {
                        this.participant.prepareCompareInput(node, configuration, monitor);
                    }
                } else {
                    ISynchronizationCompareInput adapter = this.asModelCompareInput(input);
                    if (adapter != null) {
                        adapter.prepareInput(configuration, Policy.subMonitorFor(monitor, 90));
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void checkForBufferChange(Shell shell, ICompareInput input, boolean cancelAllowed, IProgressMonitor monitor) throws CoreException {
        ISynchronizeParticipant participant = this.pageConfiguration.getParticipant();
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            if (input instanceof ISynchronizationCompareInput) {
                ISynchronizationCompareInput mci = (ISynchronizationCompareInput)input;
                msp.checkForBufferChange(shell, mci, cancelAllowed, monitor);
            }
        }
    }

    private ISynchronizationCompareInput asModelCompareInput(ICompareInput input) {
        return (ISynchronizationCompareInput)Adapters.adapt((Object)input, ISynchronizationCompareInput.class);
    }

    public boolean isSaveNeeded() {
        ModelSynchronizeParticipant msp;
        SaveableComparison currentBuffer;
        ISynchronizeParticipant iSynchronizeParticipant = this.participant;
        if (iSynchronizeParticipant instanceof ModelSynchronizeParticipant && (currentBuffer = (msp = (ModelSynchronizeParticipant)iSynchronizeParticipant).getActiveSaveable()) != null) {
            return currentBuffer.isDirty();
        }
        return super.isSaveNeeded();
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        ISynchronizeModelElement root;
        super.saveChanges(monitor);
        Object input = ((ISynchronizePage)this.page).getViewer().getInput();
        if (input instanceof ISynchronizeModelElement && (root = (ISynchronizeModelElement)input) != null && root instanceof DiffNode) {
            try {
                try {
                    ParticipantPageCompareEditorInput.commit(monitor, (DiffNode)root);
                }
                catch (CoreException e) {
                    Utils.handle(e);
                    this.setDirty(false);
                }
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left = node.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)right).commit(pm);
        }
        IDiffElement[] iDiffElementArray = children = node.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement c = iDiffElementArray[n2];
            ParticipantPageCompareEditorInput.commit(pm, (DiffNode)c);
            ++n2;
        }
    }

    @Override
    public void contentChanged(IContentChangeNotifier source) {
        super.contentChanged(source);
        try {
            if (source instanceof DiffNode) {
                ParticipantPageCompareEditorInput.commit((IProgressMonitor)new NullProgressMonitor(), (DiffNode)source);
            } else if (source instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)source).commit((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public ISynchronizePageConfiguration getPageConfiguration() {
        return this.pageConfiguration;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    public Control createContents(Composite parent) {
        if (this.shouldCreateRememberButton()) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Control control = super.createContents(composite);
            control.setLayoutData((Object)new GridData(1808));
            this.rememberParticipantButton = new Button(composite, 32);
            this.rememberParticipantButton.setText(TeamUIMessages.ParticipantCompareDialog_1);
            this.rememberParticipantButton.setLayoutData((Object)new GridData(768));
            return composite;
        }
        return super.createContents(parent);
    }

    protected boolean isOfferToRememberParticipant() {
        return true;
    }

    private boolean shouldCreateRememberButton() {
        return this.isOfferToRememberParticipant() && this.participant != null && !this.particantRegisteredWithSynchronizeManager(this.participant);
    }

    private boolean isRememberParticipant() {
        return this.getParticipant() != null && this.rememberParticipantButton != null && this.rememberParticipantButton.getSelection();
    }

    private boolean particantRegisteredWithSynchronizeManager(ISynchronizeParticipant participant) {
        return TeamUI.getSynchronizeManager().get(participant.getId(), participant.getSecondaryId()) != null;
    }

    private void rememberParticipant() {
        if (this.getParticipant() != null) {
            ISynchronizeManager mgr = TeamUI.getSynchronizeManager();
            ISynchronizeView view = mgr.showSynchronizeViewInActivePage();
            mgr.addSynchronizeParticipants(new ISynchronizeParticipant[]{this.getParticipant()});
            view.display(this.participant);
        }
    }

    public boolean okPressed() {
        if (this.isEditable()) {
            super.okPressed();
            return false;
        }
        if (this.isRememberParticipant()) {
            this.rememberParticipant();
        }
        return super.okPressed();
    }

    public void cancelPressed() {
        if (this.isEditable() && this.isRememberParticipant()) {
            this.rememberParticipant();
        }
        super.cancelPressed();
    }

    public String getOKButtonLabel() {
        if (this.isEditable()) {
            return TeamUIMessages.ParticipantPageCompareEditorInput_0;
        }
        return TeamUIMessages.ResourceMappingMergeOperation_2;
    }

    private boolean isEditable() {
        return this.getCompareConfiguration().isLeftEditable() || this.getCompareConfiguration().isRightEditable();
    }

    public String getCancelButtonLabel() {
        return TeamUIMessages.ResourceMappingMergeOperation_2;
    }
}

