/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.changes;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.changes.AbstractCElementRenameChange;
import org.eclipse.cdt.internal.ui.refactoring.changes.Messages;
import org.eclipse.cdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public final class RenameTranslationUnitChange
extends AbstractCElementRenameChange {
    public RenameTranslationUnitChange(ITranslationUnit tu, String newName) {
        this(tu.getResource().getFullPath(), tu.getElementName(), newName, -1L);
    }

    private RenameTranslationUnitChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.setValidationMethod(5);
    }

    @Override
    protected IPath createNewPath() {
        IPath path = this.getResourcePath();
        return path.removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws CModelException {
        return new RenameTranslationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        ITranslationUnit tu = (ITranslationUnit)this.getModifiedElement();
        if (tu != null) {
            tu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameTranslationUnitChange_name, (Object)BasicElementLabels.getCElementName(this.getOldName()), (Object)BasicElementLabels.getCElementName(this.getNewName()));
    }
}

