/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.ILog;

public class CLIAddressableSizeInfo
extends MIInfo {
    private static final Pattern HEX_DIGITS_PATTERN = Pattern.compile("0x([0-9a-fA-F]+)");
    private int fAddressableSize = 1;

    public CLIAddressableSizeInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput) {
                    String line = ((MIConsoleStreamOutput)oob).getString().trim();
                    this.fAddressableSize = this.hexToOctetCount(line);
                }
                ++n2;
            }
        }
    }

    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    private int hexToOctetCount(String hexString) {
        Matcher matcher = HEX_DIGITS_PATTERN.matcher(hexString);
        if (matcher.find()) {
            return matcher.group(1).length() / 2;
        }
        ILog.get().error("CLIAddressableSizeInfo response not handled: " + hexString);
        return 1;
    }
}

