/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.nsedit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.EditNamespaceInfoDialog;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonAddNamespacesDialog;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonNamespaceInfoTable;

public class CommonEditNamespacesDialog {
    protected Composite commonComposite;
    protected Button deleteButton;
    protected Button editButton;
    protected Label errorMessageLabel;
    protected int heightHint = 250;
    protected List namespaceInfoList = new ArrayList();
    protected Button newButton;
    protected IPath resourceLocation;
    private boolean showLocationText = false;
    protected String tableLabel = "";
    protected CommonNamespaceInfoTable tableViewer;
    protected Composite topComposite;
    protected boolean useGroup;
    protected int widthHint = 500;

    public CommonEditNamespacesDialog(Composite parent, IPath resourceLocation, String stringTableLabel) {
        this(parent, resourceLocation, stringTableLabel, false, false);
    }

    public CommonEditNamespacesDialog(Composite parent, IPath resourceLocation, String stringTableLabel, boolean useGroup, boolean showLocText) {
        this.resourceLocation = resourceLocation;
        this.tableLabel = stringTableLabel;
        this.useGroup = useGroup;
        this.showLocationText = showLocText;
        GridData gd = new GridData(1808);
        if (this.widthHint != -1) {
            gd.widthHint = this.widthHint;
        }
        if (this.heightHint != -1) {
            gd.heightHint = this.heightHint;
        }
        parent.setLayoutData((Object)gd);
        parent.setLayout((Layout)new GridLayout());
        this.topComposite = new Composite(parent, 0);
        GridData topData = new GridData(768);
        topData.heightHint = 0;
        this.topComposite.setLayoutData((Object)topData);
        this.topComposite.setLayout((Layout)new GridLayout());
        this.commonComposite = useGroup ? new Group(parent, 0) : new Composite(parent, 0);
        this.commonComposite.setLayoutData((Object)new GridData(1808));
        this.commonComposite.setLayout((Layout)new GridLayout(3, false));
        this.errorMessageLabel = new Label(parent, 0);
        this.errorMessageLabel.setLayoutData((Object)this.createHorizontalFill());
        Color color = new Color((Device)this.errorMessageLabel.getDisplay(), 200, 0, 0);
        this.errorMessageLabel.setForeground(color);
        this.createControlArea();
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == CommonEditNamespacesDialog.this.newButton) {
                    CommonEditNamespacesDialog.this.performNew();
                } else if (e.widget == CommonEditNamespacesDialog.this.editButton) {
                    CommonEditNamespacesDialog.this.performEdit();
                } else if (e.widget == CommonEditNamespacesDialog.this.deleteButton) {
                    CommonEditNamespacesDialog.this.performDelete();
                }
            }
        };
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)this.createHorizontalFill());
        GridLayout buttonGridLayout = new GridLayout();
        buttonComposite.setLayout((Layout)buttonGridLayout);
        this.newButton = new Button(buttonComposite, 0);
        this.newButton.setText("   " + XMLUIMessages.CommonEditNamespacesDialog_0 + "   ");
        this.newButton.setLayoutData((Object)new GridData(768));
        this.newButton.addSelectionListener((SelectionListener)selectionListener);
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(XMLUIMessages._UI_BUTTON_EDIT);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)selectionListener);
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setText(XMLUIMessages._UI_BUTTON_DELETE);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)selectionListener);
    }

    private void createControlArea() {
        if (this.useGroup) {
            ((Group)this.commonComposite).setText(this.tableLabel);
        } else {
            Label label = new Label(this.commonComposite, 0);
            label.setText(this.tableLabel);
            label.setLayoutData((Object)this.createGridData(false, 3));
        }
        this.tableViewer = new CommonNamespaceInfoTable(this.commonComposite, 6, this.showLocationText);
        this.tableViewer.getControl().setLayoutData((Object)this.createGridData(true, 2));
        this.createButtons(this.commonComposite);
        this.tableViewer.setInput(this.namespaceInfoList);
        this.updateButtonEnabledState();
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommonEditNamespacesDialog.this.updateButtonEnabledState();
            }
        };
        this.tableViewer.addSelectionChangedListener(selectionChangedListener);
    }

    protected GridData createGridData(boolean both, int span) {
        GridData gd = new GridData(both ? 1808 : 768);
        gd.horizontalSpan = 2;
        return gd;
    }

    private GridData createHorizontalFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public NamespaceInfo getNamespaceInfo(String namespace) {
        NamespaceInfo result = null;
        for (NamespaceInfo info : this.namespaceInfoList) {
            if (info.uri == null || !info.uri.equals(namespace)) continue;
            result = info;
            break;
        }
        return result;
    }

    protected Object getSelection(ISelection selection) {
        IStructuredSelection es;
        Iterator i;
        if (selection == null) {
            return null;
        }
        Object result = null;
        if (selection instanceof IStructuredSelection && (i = (es = (IStructuredSelection)selection).iterator()).hasNext()) {
            result = i.next();
        }
        return result;
    }

    protected Composite getTopComposite() {
        return this.topComposite;
    }

    protected EditNamespaceInfoDialog invokeDialog(String title, NamespaceInfo info) {
        EditNamespaceInfoDialog dialog = new EditNamespaceInfoDialog(this.topComposite.getShell(), info);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.setResourceLocation(this.resourceLocation);
        dialog.open();
        return dialog;
    }

    protected void performDelayedUpdate() {
        this.tableViewer.refresh();
    }

    public void performDelete() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.namespaceInfoList.removeAll(structuredSelection.toList());
            this.updateErrorMessage(this.namespaceInfoList);
            this.performDelayedUpdate();
        }
    }

    public void performEdit() {
        Object selection = this.getSelection(this.tableViewer.getSelection());
        if (selection != null) {
            this.invokeDialog(XMLUIMessages._UI_LABEL_NEW_NAMESPACE_INFORMATION, (NamespaceInfo)selection);
            this.updateErrorMessage(this.namespaceInfoList);
            this.performDelayedUpdate();
        }
    }

    public void performNew() {
        CommonAddNamespacesDialog dialog = new CommonAddNamespacesDialog(this.topComposite.getShell(), XMLUIMessages._UI_ADD_NAMESPACE_DECLARATIONS, this.resourceLocation, this.namespaceInfoList);
        dialog.createAndOpen();
        if (dialog.getReturnCode() == 0) {
            this.namespaceInfoList.addAll(dialog.getNamespaceInfoList());
            this.updateErrorMessage(this.namespaceInfoList);
            this.performDelayedUpdate();
        }
    }

    public void setNamespaceInfoList(List list) {
        this.namespaceInfoList = list;
        this.tableViewer.setInput(this.namespaceInfoList);
    }

    public void updateButtonEnabledState() {
        Object selection = this.getSelection(this.tableViewer.getSelection());
        NamespaceInfo info = (NamespaceInfo)selection;
        this.editButton.setEnabled(info != null);
        this.deleteButton.setEnabled(info != null && info.getProperty("unremovable") == null);
    }

    public void updateErrorMessage(List namespaceInfoList) {
        NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
        String errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
    }

    public void setResourcePath(IPath path) {
        this.resourceLocation = path;
    }
}

