/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.swt.graphics.Image;

public class BuildSummaryLabelProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        ImageDescriptor descriptor;
        if (element instanceof IBuildPlan && (descriptor = this.getImageDescriptor((IBuildPlan)element)) != null) {
            return CommonImages.getImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    private ImageDescriptor getImageDescriptor(IBuildPlan element) {
        int health = element.getHealth();
        return BuildSummaryLabelProvider.getHealthImageDescriptor(health);
    }

    public static ImageDescriptor getHealthImageDescriptor(int health) {
        if (health >= 0 && health <= 20) {
            return BuildImages.HEALTH_00;
        }
        if (health > 20 && health <= 40) {
            return BuildImages.HEALTH_20;
        }
        if (health > 40 && health <= 60) {
            return BuildImages.HEALTH_40;
        }
        if (health > 60 && health <= 80) {
            return BuildImages.HEALTH_60;
        }
        if (health > 80) {
            return BuildImages.HEALTH_80;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IBuildPlan) {
            return ((IBuildPlan)element).getSummary();
        }
        if (element instanceof IBuild) {
            return ((IBuild)element).getSummary();
        }
        return null;
    }
}

