/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.parser.definitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.Namespace;
import org.eclipse.dltk.tcl.definitions.Scope;
import org.eclipse.dltk.tcl.parser.ISubstitutionManager;
import org.eclipse.dltk.tcl.parser.definitions.BuiltinCommandUtils;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.emf.common.util.EList;

public class NamespaceScopeProcessor
implements IScopeProcessor {
    private Set<Scope> scopes = new HashSet<Scope>();
    private Map<String, Set<Command>> commands = new HashMap<String, Set<Command>>();
    private Stack<TclCommand> commandStack = new Stack();

    public NamespaceScopeProcessor() {
    }

    public NamespaceScopeProcessor(NamespaceScopeProcessor coreProcessor) {
        this.scopes = coreProcessor.scopes;
        this.commands = coreProcessor.commands;
    }

    public void addScope(Scope scope) {
        if (this.scopes.add(scope)) {
            this.fillCommandsMap(scope, "");
        }
    }

    private void fillCommandsMap(Scope scope, String prefix) {
        String namePrefix = prefix;
        if (scope instanceof Namespace) {
            namePrefix = String.valueOf(namePrefix) + ((Namespace)scope).getName() + "::";
        }
        EList<Scope> children = scope.getChildren();
        for (Scope child : children) {
            this.fillCommandsMap(child, namePrefix);
        }
        if (scope instanceof Command) {
            Set<Command> commands;
            Command command = (Command)scope;
            String key = String.valueOf(namePrefix) + command.getName();
            if (key.startsWith("::")) {
                key = key.substring(2);
            }
            if ((commands = this.commands.get(key)) == null) {
                commands = new HashSet<Command>();
            }
            commands.add(command);
            this.commands.put(key, commands);
        }
    }

    @Override
    public Command[] getCommandDefinition(String command) {
        if (command.startsWith("::")) {
            String commandName = command.substring(2);
            return this.getCommandsByName(commandName);
        }
        String[] namespacePrefix = this.calculatePrefixes(this.commandStack);
        int i = namespacePrefix.length;
        while (i >= 1) {
            Command[] cmnd = this.getCommandsByName(String.valueOf(namespacePrefix[i - 1]) + command);
            if (cmnd != null && cmnd.length > 0) {
                return cmnd;
            }
            --i;
        }
        return null;
    }

    private Command[] getCommandsByName(String commandName) {
        Set<Command> list;
        if (commandName.startsWith("::")) {
            commandName = commandName.substring(2);
        }
        if ((list = this.commands.get(commandName)) == null) {
            return new Command[0];
        }
        return list.toArray(new Command[list.size()]);
    }

    private String[] calculatePrefixes(Stack<TclCommand> commands) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> results = new ArrayList<String>();
        results.add("");
        int i = 0;
        while (i < commands.size()) {
            String name;
            TclCommand command = (TclCommand)commands.get(i);
            Command definition = command.getDefinition();
            if (definition != null && definition.getName().equals("namespace") && (name = BuiltinCommandUtils.getNamespaceEvalName(command, definition)) != null) {
                if (name.startsWith("::")) {
                    buffer.setLength(0);
                    name = name.substring(2);
                    buffer.append(String.valueOf(name) + "::");
                } else {
                    buffer.append(String.valueOf(name) + "::");
                }
                results.add(buffer.toString());
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public void processCommand(TclCommand command) {
        this.commandStack.push(command);
    }

    @Override
    public void endProcessCommand() {
        this.commandStack.pop();
    }

    public NamespaceScopeProcessor copy() {
        NamespaceScopeProcessor processor = new NamespaceScopeProcessor();
        processor.commands = new HashMap<String, Set<Command>>(this.commands);
        processor.scopes = new HashSet<Scope>(this.scopes);
        return processor;
    }

    @Override
    public String getQualifiedName(String command) {
        if (command.startsWith("::")) {
            String commandName = command.substring(2);
            return commandName;
        }
        String[] namespacePrefix = this.calculatePrefixes(this.commandStack);
        String result = command;
        int i = namespacePrefix.length;
        while (i >= 1) {
            String name = String.valueOf(namespacePrefix[i - 1]) + command;
            Command[] cmnd = this.getCommandsByName(name);
            if (cmnd != null && cmnd.length > 0) {
                return name;
            }
            if (i == namespacePrefix.length) {
                result = name;
            }
            --i;
        }
        return result;
    }

    @Override
    public ISubstitutionManager getSubstitutionManager() {
        return null;
    }

    public Command[] getCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Collection<Set<Command>> values = this.commands.values();
        for (Set<Command> set : values) {
            commands.addAll(set);
        }
        return commands.toArray(new Command[commands.size()]);
    }

    @Override
    public boolean checkCommandScope(Command command) {
        EList<Command> scopes = command.getScope();
        if (scopes == null || scopes.size() == 0) {
            return true;
        }
        for (Command scope : scopes) {
            String name = scope.getName();
            for (TclCommand tclCommand : this.commandStack) {
                if (!name.equals(tclCommand.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }
}

