/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.popup.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.validators.core.IResourceValidator;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.internal.ui.ValidatorsUI;
import org.eclipse.dltk.validators.internal.ui.popup.actions.Messages;
import org.eclipse.dltk.validators.ui.AbstractConsoleValidateJob;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;

public class RemoveMarkersAction
extends Action {
    static final String CLEANUP_IMAGE = "icons/clear_co.gif";
    private final IValidator validator;
    private final IModelElement element;

    public RemoveMarkersAction(IValidator validator, IModelElement element) {
        this.validator = validator;
        this.element = element;
        this.setText(NLS.bind((String)Messages.DLTKValidatorsEditorContextMenu_validatorCleanup, (Object)validator.getName()));
        this.setImageDescriptor(ValidatorsUI.getDefault().getImageDescriptor(CLEANUP_IMAGE));
    }

    public void run() {
        String message = NLS.bind((String)Messages.DLTKValidatorsEditorContextMenu_validatorCleanup, (Object)this.validator.getName());
        AbstractConsoleValidateJob delegate = new AbstractConsoleValidateJob(message){

            protected boolean isConsoleRequired() {
                return false;
            }

            protected void invokeValidationFor(IValidatorOutput out, IScriptProject project, ISourceModule[] modules, IResource[] resources, IProgressMonitor monitor) {
                IResourceValidator resourceValidator;
                ISourceModuleValidator sourceModuleValidator = (ISourceModuleValidator)RemoveMarkersAction.this.validator.getValidator(project, ISourceModuleValidator.class);
                if (sourceModuleValidator != null) {
                    sourceModuleValidator.clean(modules);
                }
                if ((resourceValidator = (IResourceValidator)RemoveMarkersAction.this.validator.getValidator(project, IResourceValidator.class)) != null) {
                    resourceValidator.clean(resources);
                }
            }
        };
        delegate.run(new Object[]{this.element});
    }
}

