/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.wizards;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.tcl.internal.ui.TclImages;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectTemplateEntry;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectTemplateManager;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizardFirstPage;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizardSecondPage;
import org.eclipse.dltk.tcl.internal.ui.wizards.TclWizardMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.IProjectTemplate;
import org.eclipse.dltk.ui.wizards.ProjectWizard;
import org.eclipse.dltk.utils.LazyExtensionManager;
import org.eclipse.jface.wizard.IWizardPage;

public class TclProjectCreationWizard
extends ProjectWizard {
    public static final String ID_WIZARD = "org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizard";
    protected TclProjectWizardFirstPage fFirstPage;
    protected TclProjectWizardSecondPage fSecondPage;
    private final List<TclProjectTemplateEntry> fOptions = new ArrayList<TclProjectTemplateEntry>();
    private boolean optionsLoaded = false;
    private final Map<IWizardPage, TclProjectTemplateEntry> optional = new IdentityHashMap<IWizardPage, TclProjectTemplateEntry>();

    public TclProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(TclImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(TclWizardMessages.ProjectCreationWizard_title);
    }

    private void loadOptions() {
        TclProjectTemplateManager manager = new TclProjectTemplateManager();
        for (LazyExtensionManager.Descriptor descriptor : manager.descriptors()) {
            IProjectTemplate template = (IProjectTemplate)descriptor.get();
            if (template == null) continue;
            String id = descriptor.getAttribute("id");
            String name = descriptor.getAttribute("name");
            TclProjectTemplateEntry entry = new TclProjectTemplateEntry(id, name, template);
            this.fOptions.add(entry);
        }
    }

    public String getScriptNature() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public void addPages() {
        super.addPages();
        if (!this.optionsLoaded) {
            this.loadOptions();
            this.optionsLoaded = true;
        }
        this.fFirstPage = new TclProjectWizardFirstPage(this.fOptions);
        this.addPage((IWizardPage)this.fFirstPage);
        for (TclProjectTemplateEntry entry : this.fOptions) {
            for (IWizardPage page : entry.getTemplate().getPages()) {
                this.addPage(page);
                this.optional.put(page, entry);
            }
        }
        this.fSecondPage = new TclProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    public boolean isEnabledPage(IWizardPage page) {
        TclProjectTemplateEntry entry = this.optional.get(page);
        return entry == null || entry.isSelected();
    }
}

