/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.filters.IFilterElementNameProvider;
import org.eclipse.dltk.tcl.internal.ui.navigation.ElementsView;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

class PackageFilterAction
extends Action {
    StructuredViewer fViewer;
    SimplePackagesContentProvider provider;
    ILabelProvider labelProvider;
    private PackageFilter fFilter;
    private IPreferenceStore fStore;
    String preferenceKey;

    private String getElementName(Viewer viewer, Object element) {
        String matchName = null;
        if (element instanceof IModelElement) {
            matchName = viewer instanceof IFilterElementNameProvider ? ((IFilterElementNameProvider)viewer).getElementName((Object)((IModelElement)element)) : ((IModelElement)element).getElementName();
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IModelElement modelElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
            if (modelElement != null) {
                matchName = viewer instanceof IFilterElementNameProvider ? ((IFilterElementNameProvider)viewer).getElementName((Object)modelElement) : modelElement.getElementName();
            } else {
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null) {
                    matchName = resource.getName();
                }
            }
        }
        return matchName;
    }

    private IPackageDeclaration getPackageDeclaration(IModelElement element) {
        IPackageDeclaration result = null;
        try {
            while (element != null && !(element instanceof IScriptProject)) {
                IModelElement parentElement = element.getParent();
                IParent parent = (IParent)parentElement;
                IModelElement[] childs = parent.getChildren();
                int i = 0;
                while (i < childs.length) {
                    if (childs[i] instanceof IPackageDeclaration) {
                        result = (IPackageDeclaration)childs[i];
                        break;
                    }
                    ++i;
                }
                element = parentElement;
            }
        }
        catch (ModelException modelException) {}
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPackageDeclaration[] getPackageDeclaration(Object element) {
        List modelElements = null;
        if (element instanceof IModelElement) {
            modelElements = new ArrayList<IModelElement>();
            modelElements.add((IModelElement)element);
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            modelElements = (List)adaptable.getAdapter(List.class);
        }
        ArrayList<IPackageDeclaration> result = new ArrayList<IPackageDeclaration>();
        ArrayList<IModelElement> arrayList = modelElements;
        synchronized (arrayList) {
            for (IModelElement e : modelElements) {
                IPackageDeclaration p = this.getPackageDeclaration(e);
                if (p == null) continue;
                result.add(p);
            }
        }
        return result.toArray(new IPackageDeclaration[result.size()]);
    }

    public PackageFilterAction(ElementsView view, StructuredViewer viewer) {
        this.fViewer = viewer;
        this.fStore = view.getStore();
        this.preferenceKey = view.getPreferencesId();
        this.setText("Filter by package...");
        this.provider = new SimplePackagesContentProvider();
        this.labelProvider = new SimplePackageLabelProvider();
        this.fFilter = new PackageFilter();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
        this.update();
    }

    private String getPreferenceKey() {
        return String.valueOf(this.preferenceKey) + "PackagesFilterList";
    }

    private void update() {
        String list = this.fStore.getString(this.getPreferenceKey());
        String[] data = list.split("#,#");
        this.fFilter.setElements(data);
        this.fViewer.refresh();
    }

    private void addElements(IModelElement element) {
        if (element instanceof IType || element instanceof IMethod) {
            return;
        }
        if (element instanceof IPackageDeclaration) {
            String str = this.getElementName((Viewer)this.fViewer, element);
            if (!this.provider.elements.containsKey(str)) {
                this.provider.elements.put(str, element);
            }
            return;
        }
        if (element instanceof IParent) {
            IModelElement[] children = null;
            try {
                children = ((IParent)element).getChildren();
            }
            catch (ModelException e) {
                e.printStackTrace();
                return;
            }
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    this.addElements(children[j]);
                    ++j;
                }
            }
        }
    }

    public void run() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                PackageFilterAction.this.provider.elements.clear();
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    try {
                        IScriptProject project;
                        if (projects[i].hasNature("org.eclipse.dltk.tcl.core.nature") && (project = DLTKCore.create((IProject)projects[i])) != null) {
                            PackageFilterAction.this.addElements((IModelElement)project);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        });
        CheckedTreeSelectionDialog dlg = new CheckedTreeSelectionDialog(null, this.labelProvider, (ITreeContentProvider)this.provider);
        dlg.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dlg.setTitle("Select packages");
        dlg.setMessage("Select packages to be shown in view");
        if (dlg.open() == 0) {
            Object[] res = dlg.getResult();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < res.length) {
                String elemName;
                if (res[i] instanceof String && (elemName = (String)res[i]) != null) {
                    buf.append(elemName);
                    buf.append("#,#");
                }
                ++i;
            }
            String list = buf.toString();
            this.fStore.setValue(this.getPreferenceKey(), list);
            this.update();
        }
    }

    private class PackageFilter
    extends ViewerFilter {
        List elements = new ArrayList();

        private PackageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IPackageDeclaration[] decl = PackageFilterAction.this.getPackageDeclaration(element);
            if (decl == null) {
                return false;
            }
            boolean good = false;
            int i = 0;
            while (i < decl.length) {
                String matchName = PackageFilterAction.this.getElementName(viewer, decl[i]);
                if (matchName != null) {
                    for (String str : this.elements) {
                        if (!str.equals(matchName)) continue;
                        good = true;
                        break;
                    }
                }
                if (good) break;
                ++i;
            }
            return good;
        }

        void setElements(String[] strs) {
            this.elements.clear();
            int i = 0;
            while (i < strs.length) {
                this.elements.add(strs[i]);
                ++i;
            }
        }
    }

    private class SimplePackageLabelProvider
    extends ScriptUILabelProvider
    implements IBaseLabelProvider {
        private SimplePackageLabelProvider() {
        }

        public Image getImage(Object element) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.png");
        }

        public String getOriginalText(Object element) {
            return super.getText(element);
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof IPackageDeclaration) {
                return ((IPackageDeclaration)element).getElementName();
            }
            return super.getText(element);
        }
    }

    private class SimplePackagesContentProvider
    implements ITreeContentProvider {
        private Object[] NO_ELEMENT = new Object[0];
        protected Map elements = new HashMap();

        public synchronized Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IWorkspaceRoot) {
                return this.elements.keySet().toArray();
            }
            return this.NO_ELEMENT;
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return ResourcesPlugin.getWorkspace().getRoot();
            }
            return this.NO_ELEMENT;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IWorkspaceRoot;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

