/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.core.TclParseUtil;

public class TclASTBuilder {
    public static final int TYPE_MODULE = 0;
    public static final int TYPE_NAMESPACE = 1;
    public static final int TYPE_PROC = 2;
    public static final int TYPE_UNKNOWN = 3;

    private static void replaceChild(ASTNode node, ASTNode statement, ASTNode nsType) {
        if (node instanceof ModuleDeclaration) {
            List statements = ((ModuleDeclaration)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        } else if (node instanceof TypeDeclaration) {
            List statements = ((TypeDeclaration)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        } else if (node instanceof Block) {
            List statements = ((Block)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        }
    }

    public static void rebuildMethods(TclModuleDeclaration unit) {
        MethodDeclaration[] methods;
        TypeDeclaration[] types = unit.getTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                TclASTBuilder.rebuildMethodProcessBodies(type, unit);
                ++i;
            }
        }
        if ((methods = unit.getFunctions()) != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration methodDeclaration;
                String name;
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration && (name = (methodDeclaration = method).getName()).indexOf("::") != -1) {
                    if (name.startsWith("::")) {
                        name = name.substring(2);
                    }
                    if (name.endsWith("::")) {
                        name = name.substring(0, name.length() - 2);
                    }
                    name = name.replaceAll("(::)+", "::");
                    String[] split = TclParseUtil.tclSplit(name);
                    methodDeclaration.setName(split[split.length - 1]);
                    TypeDeclaration type = TclASTBuilder.searchCreateTypeDeclaration(unit, split, method, 0);
                    if (type != null) {
                        unit.getStatements().remove(methodDeclaration);
                        unit.getFunctionList().remove(methodDeclaration);
                        type.getStatements().add(methodDeclaration);
                        type.getMethodList().add(methodDeclaration);
                    }
                }
                ++i;
            }
        }
    }

    private static TypeDeclaration searchCreateTypeDeclaration(TclModuleDeclaration unit, String[] split, MethodDeclaration method, int offset) {
        if (split.length - 1 <= offset) {
            return null;
        }
        String typeName = split[0 + offset];
        TypeDeclaration[] types = unit.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getName().equals(typeName)) {
                return TclASTBuilder.searchCreateTypeDeclaration(types[i], split, method, offset + 1);
            }
            ++i;
        }
        TypeDeclaration decl = new TypeDeclaration(typeName, method.getNameStart(), method.getNameEnd(), method.sourceStart(), method.sourceEnd());
        unit.addStatement((ASTNode)decl);
        unit.getTypeList().add(decl);
        return TclASTBuilder.searchCreateTypeDeclaration(decl, split, method, offset + 1);
    }

    private static TypeDeclaration searchCreateTypeDeclaration(TypeDeclaration typeDeclaration, String[] split, MethodDeclaration method, int offset) {
        if (offset == split.length - 1) {
            return typeDeclaration;
        }
        String typeName = split[0 + offset];
        TypeDeclaration[] types = typeDeclaration.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getName().equals(typeName)) {
                return TclASTBuilder.searchCreateTypeDeclaration(types[i], split, method, offset + 1);
            }
            ++i;
        }
        TypeDeclaration decl = new TypeDeclaration(typeName, method.getNameStart(), method.getNameEnd(), method.sourceStart(), method.sourceEnd());
        typeDeclaration.getStatements().add(decl);
        typeDeclaration.getTypeList().add(decl);
        return TclASTBuilder.searchCreateTypeDeclaration(decl, split, method, offset + 1);
    }

    protected static void rebuildMethodProcessBodies(TypeDeclaration type, TclModuleDeclaration module) {
        TypeDeclaration[] memberTypes;
        MethodDeclaration[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration methodDeclaration;
                String name;
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration && (name = (methodDeclaration = method).getName()).indexOf("::") != -1) {
                    boolean start = false;
                    if (name.startsWith("::")) {
                        name = name.substring(2);
                        start = true;
                    }
                    if (name.endsWith("::")) {
                        name = name.substring(0, name.length() - 2);
                    }
                    name = name.replaceAll("(::)+", "::");
                    String[] split = TclParseUtil.tclSplit(name);
                    if (start && split.length > 2) {
                        module.getFunctionList().add(methodDeclaration);
                        type.getMethodList().remove(methodDeclaration);
                        type.getStatements().remove(methodDeclaration);
                    } else {
                        method.setName(split[split.length - 1]);
                        TypeDeclaration decl = TclASTBuilder.searchCreateTypeDeclaration(type, split, method, 0);
                        if (decl != null) {
                            type.getMethodList().remove(methodDeclaration);
                            type.getStatements().remove(methodDeclaration);
                            decl.getStatements().add(method);
                            decl.getMethodList().add(method);
                        }
                    }
                }
                ++i;
            }
        }
        if ((memberTypes = type.getTypes()) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                TypeDeclaration memberType = memberTypes[i];
                TclASTBuilder.rebuildMethodProcessBodies(memberType, module);
                ++i;
            }
        }
    }
}

