/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.editor.highlighting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.ui.editor.highlighting.IHighlightedPositionFactory;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.jface.text.Position;

public abstract class AbstractSemanticHighlighter
implements ISemanticHighlightingUpdater,
ISemanticHighlightingRequestor {
    private IHighlightedPositionFactory positionFactory;
    private Map<String, HighlightingStyle> highlightingStyles = new HashMap<String, HighlightingStyle>();
    private final List<HighlightedPosition> newPositions = new ArrayList<HighlightedPosition>();
    private int oldPositionCount = 0;
    private final List<HighlightedPosition> oldPositions = new ArrayList<HighlightedPosition>();
    private static final boolean DEBUG = false;

    @Override
    public void initialize(IHighlightedPositionFactory factory, HighlightingStyle[] styles) {
        this.positionFactory = factory;
        this.highlightingStyles.clear();
        if (styles != null) {
            HighlightingStyle[] highlightingStyleArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                HighlightingStyle style = highlightingStyleArray[n2];
                this.highlightingStyles.put(style.getSemaHighlighting().getPreferenceKey(), style);
                ++n2;
            }
        }
    }

    @Override
    public ISemanticHighlightingUpdater.UpdateResult reconcile(IModuleSource code, List<HighlightedPosition> currentPositions) {
        try {
            this.newPositions.clear();
            this.oldPositionCount = currentPositions.size();
            this.oldPositions.clear();
            this.oldPositions.addAll(currentPositions);
            if (this.doHighlighting(code)) {
                this.checkNewPositionOrdering();
                HighlightedPosition[] removed = this.getRemovedPositions();
                return new ISemanticHighlightingUpdater.UpdateResult(this.getAddedPositions(), removed);
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)"Error in SemanticPositionUpdater", (Throwable)e);
        }
        return new ISemanticHighlightingUpdater.UpdateResult(HighlightedPosition.NO_POSITIONS, HighlightedPosition.NO_POSITIONS);
    }

    protected abstract boolean doHighlighting(IModuleSource var1) throws Exception;

    @Override
    public void addPosition(int start, int end, String highlightingKey) {
        HighlightedPosition p;
        int len = end - start;
        if (len <= 0) {
            return;
        }
        HighlightingStyle hl = this.highlightingStyles.get(highlightingKey);
        if (hl == null) {
            return;
        }
        int i = 0;
        int size = this.oldPositions.size();
        while (i < size) {
            p = this.oldPositions.get(i);
            if (p != null && p.isEqual(start, len, hl)) {
                this.oldPositions.set(i, null);
                --this.oldPositionCount;
                return;
            }
            ++i;
        }
        if (!this.newPositions.isEmpty()) {
            int lowBound = Math.max(this.newPositions.size() - 2, 0);
            int i2 = this.newPositions.size();
            while (--i2 >= lowBound) {
                p = this.newPositions.get(i2);
                if (!p.isEqual(start, len, hl)) continue;
                return;
            }
        }
        HighlightedPosition hp = this.positionFactory.createHighlightedPosition(start, len, hl);
        this.newPositions.add(hp);
    }

    protected HighlightedPosition[] getAddedPositions() {
        HighlightedPosition[] result = new HighlightedPosition[this.newPositions.size()];
        this.newPositions.toArray(result);
        return result;
    }

    protected HighlightedPosition[] getRemovedPositions() {
        HighlightedPosition[] result = new HighlightedPosition[this.oldPositionCount];
        int index = 0;
        int i = 0;
        int size = this.oldPositions.size();
        while (i < size) {
            HighlightedPosition p = this.oldPositions.get(i);
            if (p != null) {
                result[index++] = p;
            }
            ++i;
        }
        return result;
    }

    protected void checkNewPositionOrdering() {
        if (this.newPositions.isEmpty()) {
            return;
        }
        Collections.sort(this.newPositions, new Comparator<HighlightedPosition>(){

            @Override
            public int compare(HighlightedPosition p1, HighlightedPosition p2) {
                return p1.getOffset() - p2.getOffset();
            }
        });
        Position previous = null;
        Iterator<HighlightedPosition> i = this.newPositions.iterator();
        while (i.hasNext()) {
            Position current = i.next();
            if (previous != null && previous.getOffset() + previous.getLength() > current.getOffset()) {
                i.remove();
                continue;
            }
            previous = current;
        }
    }
}

