/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptBreakpointPropertyPage;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.widgets.Composite;

public class ScriptLineBreakpointPropertyPage
extends ScriptBreakpointPropertyPage {
    @Override
    protected void createLocationLabels(Composite parent) throws CoreException {
        super.createLocationLabels(parent);
        IScriptLineBreakpoint breakpoint = (IScriptLineBreakpoint)this.getBreakpoint();
        int lineNumber = breakpoint.getLineNumber();
        SWTFactory.createLabel((Composite)parent, (String)BreakpointMessages.LineNumberLabel, (int)1);
        SWTFactory.createLabel((Composite)parent, (String)Integer.toString(lineNumber), (int)1);
    }

    @Override
    protected String getBreakpointLocationLabel() {
        IScriptLineBreakpoint lineBP;
        IResource resource;
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IScriptLineBreakpoint && (resource = (lineBP = (IScriptLineBreakpoint)breakpoint).getResource()) != null) {
            return BreakpointMessages.ResourceLabel;
        }
        return super.getBreakpointLocationLabel();
    }

    @Override
    protected String getBreakpointResourceName() throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint instanceof IScriptLineBreakpoint) {
            IScriptLineBreakpoint lineBP = (IScriptLineBreakpoint)breakpoint;
            IResource resource = lineBP.getResource();
            if (resource != null) {
                return resource.getFullPath().toString();
            }
            IPath path = lineBP.getResourcePath();
            if (path != null) {
                return EnvironmentPathUtils.getLocalPath((IPath)path).toString();
            }
            URI uri = lineBP.getResourceURI();
            return uri.toString();
        }
        return super.getBreakpointResourceName();
    }
}

