/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class ForEachInStatement
extends ForInStatement {
    private Keyword eachKeyword;

    public ForEachInStatement(JSNode parent) {
        super(parent);
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            Statement body;
            if (this.eachKeyword != null) {
                this.eachKeyword.traverse(visitor);
            }
            if (this.getForKeyword() != null) {
                this.getForKeyword().traverse(visitor);
            }
            if (this.getInKeyword() != null) {
                this.getInKeyword().traverse(visitor);
            }
            if (this.getItem() != null) {
                this.getItem().traverse(visitor);
            }
            if (this.getIterator() != null) {
                this.getIterator().traverse(visitor);
            }
            if ((body = this.getBody()) != null) {
                body.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getEachKeyword() {
        return this.eachKeyword;
    }

    public void setEachKeyword(Keyword keyword) {
        this.eachKeyword = keyword;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getLP() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getRP() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("for");
        buffer.append(' ');
        buffer.append("each");
        buffer.append(" (");
        buffer.append(this.getItem().toSourceString(indentationString));
        buffer.append(" ");
        buffer.append("in");
        buffer.append(" ");
        buffer.append(this.getIterator().toSourceString(indentationString));
        buffer.append(")");
        if (this.getBody() != null) {
            buffer.append("\n");
            buffer.append(this.getBody().toSourceString(indentationString));
        } else {
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

