/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.rse;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.internal.rse.DLTKRSEPlugin;
import org.eclipse.dltk.core.internal.rse.RSEEnvironment;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.widgets.Shell;

public class RSEEnvironmentUI
implements IEnvironmentUI {
    private RSEEnvironment environment;
    private static final String FILTER_STD_SUFFIX = "/*";

    public RSEEnvironmentUI(RSEEnvironment environment) {
        this.environment = environment;
    }

    public String selectFolder(Shell shell) {
        return this.selectFolder(shell, null);
    }

    public String selectFolder(Shell shell, String initialFolder) {
        IRemoteFileSubSystem fs;
        if (!this.environment.connect(true)) {
            return null;
        }
        SystemRemoteFolderDialog dialog = new SystemRemoteFolderDialog(shell);
        dialog.setDefaultSystemConnection(this.environment.getHost(), true);
        if (initialFolder != null && initialFolder.length() != 0 && (fs = RemoteFileUtility.getFileSubSystem((IHost)this.environment.getHost())) != null) {
            try {
                IRemoteFile remoteFile = fs.getRemoteFileObject(initialFolder, (IProgressMonitor)new NullProgressMonitor());
                if (remoteFile != null && remoteFile.exists()) {
                    dialog.setPreSelection((Object)remoteFile);
                }
            }
            catch (SystemMessageException e) {
                DLTKRSEPlugin.log((Throwable)e);
            }
        }
        if (dialog.open() == 0) {
            IRemoteFileSubSystem fs2;
            String filterString;
            ISystemFilter filter;
            Object selectedObject = dialog.getSelectedObject();
            if (selectedObject instanceof IRemoteFile) {
                IRemoteFile file = (IRemoteFile)selectedObject;
                return file.getAbsolutePath();
            }
            if (selectedObject instanceof ISystemFilterReference && (filter = ((ISystemFilterReference)selectedObject).getReferencedFilter()) != null && filter.getFilterStringCount() == 1 && (filterString = filter.getFilterStrings()[0]).endsWith(FILTER_STD_SUFFIX) && (fs2 = RemoteFileUtility.getFileSubSystem((IHost)this.environment.getHost())) != null) {
                try {
                    IRemoteFile remoteFile = fs2.getRemoteFileObject(filterString.substring(0, filterString.length() - FILTER_STD_SUFFIX.length()), (IProgressMonitor)new NullProgressMonitor());
                    if (remoteFile != null) {
                        return remoteFile.getAbsolutePath();
                    }
                }
                catch (SystemMessageException e) {
                    DLTKRSEPlugin.log((Throwable)e);
                }
            }
        }
        return null;
    }

    public String selectFile(Shell shell, int fileType) {
        return this.selectFile(shell, fileType, null);
    }

    public String selectFile(Shell shell, int fileType, String initialSelection) {
        Object selectedObject;
        IRemoteFileSubSystem fs;
        if (!this.environment.connect(true)) {
            return null;
        }
        SystemRemoteFileDialog dialog = new SystemRemoteFileDialog(shell);
        dialog.setDefaultSystemConnection(this.environment.getHost(), true);
        if (initialSelection != null && initialSelection.length() != 0 && (fs = RemoteFileUtility.getFileSubSystem((IHost)this.environment.getHost())) != null) {
            try {
                IRemoteFile remoteFile = fs.getRemoteFileObject(initialSelection, (IProgressMonitor)new NullProgressMonitor());
                if (remoteFile != null && remoteFile.exists()) {
                    dialog.setPreSelection((Object)remoteFile);
                }
            }
            catch (SystemMessageException e) {
                DLTKRSEPlugin.log((Throwable)e);
            }
        }
        if (dialog.open() == 0 && (selectedObject = dialog.getSelectedObject()) instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)selectedObject;
            return file.getAbsolutePath();
        }
        return null;
    }
}

