/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.ExternalSourceModuleEditorInputFactory;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class ExternalStorageEditorInput
implements IEditorInput,
IStorageEditorInput {
    private IStorage fStorage;

    public ExternalStorageEditorInput(IStorage storage) {
        this.fStorage = storage;
    }

    public boolean exists() {
        return this.fStorage != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fStorage.getName());
    }

    public String getName() {
        return this.fStorage.getName();
    }

    public IPersistableElement getPersistable() {
        if (this.fStorage instanceof IExternalSourceModule) {
            IPersistableElement element = (IPersistableElement)Platform.getAdapterManager().getAdapter((Object)this.fStorage, IPersistableElement.class);
            if (element != null) {
                return element;
            }
            return ExternalSourceModuleEditorInputFactory.createPersistableElement((IExternalSourceModule)this.fStorage);
        }
        return null;
    }

    public String getToolTipText() {
        IPath path = this.fStorage.getFullPath();
        if (path == null) {
            return "";
        }
        if (this.fStorage instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)this.fStorage;
            IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit(modelElement);
            ScriptElementLabels labels = uiToolkit.getScriptElementLabels();
            String label = labels.getTextLabel(this.fStorage, 0x100000000000L);
            return label;
        }
        return path.toOSString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IModelElement.class && this.fStorage instanceof IModelElement) {
            return this.fStorage;
        }
        return null;
    }

    public IStorage getStorage() {
        return this.fStorage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalStorageEditorInput)) {
            return false;
        }
        ExternalStorageEditorInput other = (ExternalStorageEditorInput)obj;
        return this.fStorage.equals(other.fStorage);
    }

    public int hashCode() {
        return this.fStorage.hashCode();
    }

    public IPath getPath(Object element) {
        return this.fStorage.getFullPath();
    }
}

