/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.BundleContext;

public class JavaScriptDebugPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.javascript.debug";
    private static JavaScriptDebugPlugin fgPlugin;
    public static final int INTERNAL_ERROR = 120;
    private boolean fTrace = false;

    public static void log(IStatus status) {
        JavaScriptDebugPlugin.getDefault().getLog().log(status);
    }

    public boolean isTraceMode() {
        return this.fTrace;
    }

    public static void logTraceMessage(String message) {
        if (JavaScriptDebugPlugin.getDefault().isTraceMode()) {
            Status s = new Status(2, PLUGIN_ID, 120, message, null);
            JavaScriptDebugPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public static JavaScriptDebugPlugin getDefault() {
        return fgPlugin;
    }

    public JavaScriptDebugPlugin() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.savePluginPreferences();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            fgPlugin = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
            fgPlugin = null;
        }
        super.stop(context);
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        JavaScriptDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, 120, "Internal error logged from Tcl Debug: ", top));
    }
}

