/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

public class UntilNode
extends Node {
    static final long serialVersionUID = -2929327250252365636L;
    private final Node conditionNode;
    private final Node bodyNode;
    private final ISourcePositionHolder keyword;
    private final ISourcePositionHolder end;

    public UntilNode(ISourcePosition position, Node conditionNode, Node bodyNode, ISourcePositionHolder keyword, ISourcePositionHolder end) {
        super(position, 90);
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.keyword = keyword;
        this.end = end;
    }

    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitUntilNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    public List childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }

    public ISourcePositionHolder getKeyword() {
        return this.keyword;
    }

    public ISourcePositionHolder getEnd() {
        return this.end;
    }

    public boolean isBlock() {
        return true;
    }

    public static class Inline
    extends UntilNode {
        public Inline(ISourcePosition position, Node conditionNode, Node bodyNode, ISourcePositionHolder keyword) {
            super(position, conditionNode, bodyNode, keyword, null);
        }

        public boolean isBlock() {
            return false;
        }
    }
}

