/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import org.eclipse.dltk.tcl.internal.ui.documentation.IManPagesLocation;

public class HtmlManPagesLocation
implements IManPagesLocation {
    private File fLocation;

    public HtmlManPagesLocation(File location) {
        if (!location.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.fLocation = location;
    }

    public Reader getHtmlInfo(String keyword) {
        final String pattern = String.valueOf(keyword) + ".htm";
        File[] result = this.fLocation.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equals(pattern);
            }
        });
        if (result != null && result.length >= 1 && result[0] != null) {
            try {
                FileReader reader = new FileReader(result[0]);
                return reader;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public File getLocation() {
        return this.fLocation;
    }

    public void setLocation(File location) {
        if (!location.isDirectory()) {
            return;
        }
        this.fLocation = location;
    }
}

