/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui.wizards;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class MylynPreferenceWizardPage
extends WizardPage {
    private static final String DESCRIPTION = "Configures Mylyn preferences to the recommended defaults. To alter these\nre-invoke this wizard via the File -> New menu.";
    private static final String AUTO_FOLDING = "Turn automatic editor folding on";
    private static final String AUTO_CLOSE = "Automatically manage open editors to match task context";
    private static final String CONTENT_ASSIST = "Enable task-context ranked content assist, requires Eclipse restart.";
    private static final String CONTENT_ASSIST_WARNING = "Toggle via Preferences-><Your DLTK Language>->Editor->Content Assist->Advanced ";
    private static final String OPEN_TASK_LIST = "Open the Task List view";
    private Button contentAssistButton;
    private Button turnOnAutoFoldingButton;
    private boolean autoFolding = true;
    private boolean createWorkingSet = false;
    private Button closeEditorsOnDeactivationButton;
    private boolean closeEditors = true;
    private Button openTaskListButton;
    private boolean openTaskList = true;

    protected MylynPreferenceWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout());
        Composite buttonComposite = new Composite(containerComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)layout);
        this.contentAssistButton = new Button(buttonComposite, 32);
        GridData gd = new GridData();
        this.contentAssistButton.setLayoutData((Object)gd);
        this.contentAssistButton.setSelection(true);
        Label label = new Label(buttonComposite, 0);
        label.setText(CONTENT_ASSIST);
        label = new Label(buttonComposite, 0);
        label = new Label(buttonComposite, 0);
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setText(CONTENT_ASSIST_WARNING);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.turnOnAutoFoldingButton = new Button(buttonComposite, 32);
        gd = new GridData();
        this.turnOnAutoFoldingButton.setLayoutData((Object)gd);
        this.turnOnAutoFoldingButton.setSelection(true);
        this.turnOnAutoFoldingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MylynPreferenceWizardPage.this.autoFolding = MylynPreferenceWizardPage.this.turnOnAutoFoldingButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(buttonComposite, 0);
        label.setText(AUTO_FOLDING);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label = new Label(buttonComposite, 0);
        label = new Label(buttonComposite, 0);
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setText("Toggle via toolbar button ");
        this.closeEditorsOnDeactivationButton = new Button(buttonComposite, 32);
        gd = new GridData();
        this.closeEditorsOnDeactivationButton.setLayoutData((Object)gd);
        this.closeEditorsOnDeactivationButton.setSelection(true);
        this.closeEditorsOnDeactivationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MylynPreferenceWizardPage.this.closeEditors = MylynPreferenceWizardPage.this.closeEditorsOnDeactivationButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(buttonComposite, 0);
        label.setText(AUTO_CLOSE);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label = new Label(buttonComposite, 0);
        label = new Label(buttonComposite, 0);
        label.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        label.setText("Toggle via Mylyn preferences page ");
        this.openTaskListButton = new Button(buttonComposite, 32);
        gd = new GridData();
        this.openTaskListButton.setLayoutData((Object)gd);
        this.openTaskListButton.setSelection(true);
        this.openTaskListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MylynPreferenceWizardPage.this.openTaskList = MylynPreferenceWizardPage.this.openTaskListButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(buttonComposite, 0);
        label.setText(OPEN_TASK_LIST);
        gd = new GridData();
        label.setLayoutData((Object)gd);
        Label spacer = new Label(buttonComposite, 0);
        spacer.setText(" ");
        spacer = new Label(buttonComposite, 0);
        spacer.setText(" ");
        Hyperlink hyperlink = new Hyperlink(containerComposite, 0);
        hyperlink.setUnderlined(true);
        hyperlink.setText("If this is your first time using Mylyn please watch the short Getting Started video");
        label = new Label(containerComposite, 0);
        label.setText("For a legend of the icons used by Mylyn open: Help (menu) -> Mylar UI Legend");
        gd = new GridData();
        label.setLayoutData((Object)gd);
        hyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.setControl((Control)containerComposite);
    }

    public boolean isAutoFolding() {
        return this.autoFolding;
    }

    public boolean closeEditors() {
        return this.closeEditors;
    }

    public boolean isMylynContentAssistDefault() {
        return this.contentAssistButton.getSelection();
    }

    public boolean isCreateWorkingSet() {
        return this.createWorkingSet;
    }

    public boolean isOpenTaskList() {
        return this.openTaskList;
    }
}

