/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model.internal;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTCaching;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.IElement;
import org.eclipse.dltk.ruby.core.model.IElementCriteria;
import org.eclipse.dltk.ruby.core.model.IElementKind;
import org.eclipse.dltk.ruby.core.model.IModel;

public class Model
implements IModel {
    private final IScriptProject project;
    private final Map sourceModulesToASTs = new WeakHashMap();

    public Model(IScriptProject project) {
        this.project = project;
    }

    public ModuleDeclaration getASTNode(ISourceModule sourceModule, ASTCaching caching) {
        ModuleDeclaration result = null;
        SoftReference<ModuleDeclaration> astNode = (SoftReference<ModuleDeclaration>)this.sourceModulesToASTs.get(sourceModule);
        if (astNode != null && caching != ASTCaching.REPARSE) {
            result = (ModuleDeclaration)astNode.get();
        }
        if (result == null && caching != ASTCaching.CACHED_ONLY) {
            try {
                ISourceParser parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
                result = parser.parse(sourceModule.getPath().toString().toCharArray(), sourceModule.getSourceAsCharArray(), null);
            }
            catch (ModelException e) {
                RubyPlugin.log((Exception)((Object)e));
                result = null;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (result != null) {
                astNode = new SoftReference<ModuleDeclaration>(result);
                this.sourceModulesToASTs.put(sourceModule, astNode);
            }
        }
        return result;
    }

    public ISourceModule[] search(String name) {
        ArrayList sourceModules = new ArrayList();
        try {
            IModelElement[] children = this.project.getChildren();
            this.addModules(sourceModules, children);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return sourceModules.toArray(new ISourceModule[sourceModules.size()]);
    }

    private void addModules(Collection sourceModules, IModelElement[] children) throws ModelException {
        int i = 0;
        while (i < children.length) {
            IModelElement element = children[i];
            if (element instanceof ISourceModule) {
                sourceModules.add(element);
            } else if (element instanceof IParent) {
                this.addModules(sourceModules, ((IParent)element).getChildren());
            }
            ++i;
        }
    }

    public IElement[] findChildren(IElementCriteria criteria, String name, IProgressMonitor pm) {
        return null;
    }

    public IElement getAncestor(IElementCriteria criteria) {
        return null;
    }

    public IElementKind getElementKind() {
        return IElementKind.MODEL;
    }
}

