/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

public class DbgpStreamPacket {
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private final String type;
    private final String content;

    public DbgpStreamPacket(String type, String content) {
        if (!STDERR.equalsIgnoreCase(type) && !STDOUT.equalsIgnoreCase(type)) {
            throw new IllegalArgumentException("Invalid type value");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
        this.type = type;
        this.content = content;
    }

    public boolean isStdout() {
        return STDOUT.equalsIgnoreCase(this.type);
    }

    public boolean isStderr() {
        return STDERR.equalsIgnoreCase(this.type);
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return "DbgpStreamPacket (Type: " + this.type + "; Content: " + this.content + ";)";
    }
}

