/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.p2;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.internal.p2.director.app.DirectorApplication;
import org.eclipse.equinox.internal.p2.director.app.ILog;
import org.eclipse.tea.core.annotations.TaskCaptureStdOutput;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipExec;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.p2.TeaProductDescription;
import org.eclipse.tea.library.build.p2.UpdateSite;
import org.eclipse.tea.library.build.p2.UpdateSiteManager;
import org.eclipse.tea.library.build.tasks.p2.TaskingLogLoggerDelegate;
import org.eclipse.tea.library.build.util.FileUtils;

@TaskCaptureStdOutput
public class TaskRunProductExport {
    private final String siteName;
    private final String productFeature;
    private final String productFileName;
    private PlatformTriple[] buildPlatforms = PlatformTriple.getAllPlatforms();
    private final Map<PlatformTriple, File> outputs = new HashMap<PlatformTriple, File>();
    private final boolean zip;

    public TaskRunProductExport(String siteName, String productFeature, String productFileName, boolean zip) {
        this.siteName = siteName;
        this.productFeature = productFeature;
        this.productFileName = productFileName;
        this.zip = zip;
    }

    public String toString() {
        return "Export Product (" + this.productFeature + ")";
    }

    public void setPlatformsToBuild(PlatformTriple[] platforms) {
        this.buildPlatforms = platforms;
    }

    @Execute
    public void run(TaskingLog log, UpdateSiteManager um, JarManager jm, WorkspaceBuild wb) throws Exception {
        UpdateSite site = um.getSite(this.siteName);
        File baseProductDir = BuildDirectories.get().getProductDirectory();
        if (!site.directory.isDirectory()) {
            throw new RuntimeException("Repository '" + String.valueOf(site.directory) + "' is not existing");
        }
        TaskingLogLoggerDelegate logger = new TaskingLogLoggerDelegate(log);
        FeatureBuild feature = wb.getFeature(this.productFeature);
        File productFile = new File(((FeatureData)feature.getData()).getBundleDir(), this.productFileName);
        TeaProductDescription productDescriptor = new TeaProductDescription(productFile, feature);
        String productName = productDescriptor.getProductName();
        String productId = productDescriptor.getId();
        PlatformTriple[] platformTripleArray = this.buildPlatforms;
        int n = this.buildPlatforms.length;
        int n2 = 0;
        while (n2 < n) {
            PlatformTriple platform = platformTripleArray[n2];
            File productDir = new File(baseProductDir, productName + "-" + platform.os + "." + platform.ws + "." + platform.arch);
            String buildVersion = jm.getQualifier();
            File archivedProductFile = new File(baseProductDir, productName + "-" + buildVersion + "." + platform.os + "." + platform.ws + "." + platform.arch + ".zip");
            FileUtils.deleteDirectory(productDir);
            log.info("Building product '" + productDir.getName() + "'");
            this.createProduct(productId, site.directory, new File(productDir, productName), platform, logger);
            if (this.zip) {
                log.info("Archiving product '" + archivedProductFile.getName() + "'");
                this.createArchive(jm.getZipExecFactory(), productDir, archivedProductFile);
                FileUtils.deleteDirectory(productDir);
                this.outputs.put(platform, archivedProductFile);
            } else {
                this.outputs.put(platform, productDir);
            }
            ++n2;
        }
    }

    public File getOutput(PlatformTriple platform) {
        return this.outputs.get(platform);
    }

    public String getProductFeatureName() {
        return this.productFeature;
    }

    protected void createProduct(String productId, File repositoryDir, File destinationDir, PlatformTriple platform, ILog logger) throws Exception {
        ArrayList<Object> cmdArgs = new ArrayList<Object>();
        cmdArgs.add("-installIU");
        cmdArgs.add(productId);
        cmdArgs.add("-repository");
        cmdArgs.add("file:" + repositoryDir.getAbsolutePath());
        cmdArgs.add("-destination");
        cmdArgs.add(destinationDir.getAbsolutePath());
        cmdArgs.add("-profile");
        cmdArgs.add("WAMASProfile");
        cmdArgs.add("-roaming");
        cmdArgs.add("-profileProperties");
        cmdArgs.add("org.eclipse.update.install.features=true");
        cmdArgs.add("-p2.os");
        cmdArgs.add(platform.os);
        cmdArgs.add("-p2.ws");
        cmdArgs.add(platform.ws);
        cmdArgs.add("-p2.arch");
        cmdArgs.add(platform.arch);
        DirectorApplication directorApplication = new DirectorApplication();
        directorApplication.setLog(logger);
        Object result = directorApplication.run(cmdArgs.toArray(new String[cmdArgs.size()]));
        if (!IApplication.EXIT_OK.equals(result)) {
            throw new RuntimeException("Error occured during product export '" + String.valueOf(result) + "'");
        }
    }

    protected void createArchive(ZipExecFactory zip, File sourceDir, File archiveFile) throws Exception {
        ZipExec zipExec = zip.createZipExec();
        zipExec.setZipFile(archiveFile);
        ZipExecPart part = new ZipExecPart();
        File[] fileArray = sourceDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            part.sourceDirectory = sourceDir;
            part.relativePaths.add(file.getName());
            ++n2;
        }
        zipExec.addPart(part);
        zipExec.createZip();
    }
}

