/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;

public class TaskCleanProjectsWithErrors {
    @Execute
    public void doIt(TaskingLog log, TaskProgressTracker tracker) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        log.info("Checking " + projects.length + " projects...");
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                int severity = project.findMaxProblemSeverity(null, true, 2);
                if (severity >= 2) {
                    log.warn("CLEAN " + project.getName());
                    project.build(15, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tracker.isCanceled()) break;
            ++n2;
        }
        log.info("ready");
    }

    public String toString() {
        return "Clean Projects with Errors";
    }
}

