/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.jar.ZipExecInterceptor;
import org.eclipse.tea.library.build.model.BundleBuild;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.services.TeaBuildVersionService;
import org.eclipse.tea.library.build.util.StringHelper;

public final class JarManager {
    public static final String QUALIFIER_REP = "%D";
    private final ZipExecFactory zipExecFactory;
    private String qualifier;
    private final TaskingLog log;
    private final TeaBuildVersionService bvService;

    public JarManager(TaskingLog log, ZipExecFactory zipExecFactory, TeaBuildVersionService bvService) {
        this.log = log;
        this.zipExecFactory = zipExecFactory;
        this.bvService = bvService;
        this.reset();
    }

    public void reset() {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        this.qualifier = this.bvService.getQualifierFormat().replace(QUALIFIER_REP, format.format(now));
        this.log.debug("build qualifier: " + this.qualifier);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getBuildVersion() {
        return this.bvService.getBuildVersion().replace("qualifier", this.qualifier);
    }

    public String getBundleVersion(BundleData data) {
        return this.createNewVersion(data);
    }

    private String createNewVersion(BundleData data) {
        String origVersion = data.getBundleVersion();
        String newVersion = StringHelper.replaceQualifier(origVersion, this.qualifier);
        return newVersion;
    }

    public ZipExecFactory getZipExecFactory() {
        return this.zipExecFactory;
    }

    public File execJarCommands(BundleBuild<?> bundle, File destDirectory) throws Exception {
        boolean withSource = false;
        ZipExecInterceptor zipExecInterceptor = null;
        return this.execJarCommands(bundle, destDirectory, withSource, zipExecInterceptor);
    }

    public File execJarCommands(BundleBuild<?> bundle, File destDirectory, boolean withSource, ZipExecInterceptor zipExecInterceptor) throws Exception {
        String version = this.createNewVersion((BundleData)bundle.getData());
        return bundle.execJarCommands(this.zipExecFactory, destDirectory, version, this, withSource, zipExecInterceptor);
    }
}

