/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ContentTypeFilenameAssociationDialog;
import org.eclipse.ui.internal.dialogs.NewContentTypeDialog;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContentTypesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer fileAssociationViewer;
    private Button removeButton;
    private TreeViewer contentTypesViewer;
    private Button addButton;
    private Button editButton;
    private Text charsetField;
    private Button setButton;
    private IWorkbench workbench;
    private Button removeContentTypeButton;
    private Button addChildContentTypeButton;
    private TableViewer editorAssociationsViewer;
    private Button addEditorAssociationButton;
    private Set<Image> disposableEditorIcons = new HashSet<Image>();

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.FileEditors", WorkbenchMessages.ContentTypes_FileEditorsRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        contentTypeArea.getControl().setLayoutData((Object)data);
        this.createContentTypesTree(composite);
        this.createFileAssociations(composite);
        this.createEditors(composite);
        this.createCharset(composite);
        this.workbench.getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.content_types_preference_page_context");
        this.applyDialogFont(composite);
        return composite;
    }

    private IEditorDescriptor[] getAssociatedEditors() {
        Table editorTable = this.editorAssociationsViewer.getTable();
        if (editorTable == null) {
            return null;
        }
        if (editorTable.getItemCount() > 0) {
            ArrayList<IEditorDescriptor> editorList = new ArrayList<IEditorDescriptor>();
            int i = 0;
            while (i < editorTable.getItemCount()) {
                editorList.add((IEditorDescriptor)editorTable.getItem(i).getData());
                ++i;
            }
            return editorList.toArray(new IEditorDescriptor[editorList.size()]);
        }
        return null;
    }

    private void createEditors(Composite parent) {
        final IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_editorAssociations);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.editorAssociationsViewer = new TableViewer(composite);
        this.editorAssociationsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.editorAssociationsViewer.setContentProvider((IContentProvider)((IStructuredContentProvider)arg0 -> {
            if (arg0 instanceof IContentType) {
                return editorRegistry.getEditors(null, (IContentType)arg0);
            }
            return new Object[0];
        }));
        this.editorAssociationsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IEditorDescriptor)element).getLabel();
            }

            public Image getImage(Object element) {
                Image res = ((IEditorDescriptor)element).getImageDescriptor().createImage();
                if (res != null) {
                    ContentTypesPreferencePage.this.disposableEditorIcons.add(res);
                }
                return res;
            }
        });
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        this.addEditorAssociationButton = new Button(buttonsComposite, 8);
        this.addEditorAssociationButton.setText(WorkbenchMessages.ContentTypes_editorAssociationAddLabel);
        this.setButtonLayoutData(this.addEditorAssociationButton);
        this.addEditorAssociationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (editorRegistry instanceof EditorRegistry) {
                    EditorSelectionDialog dialog = new EditorSelectionDialog(ContentTypesPreferencePage.this.getShell());
                    dialog.setEditorsToFilter(ContentTypesPreferencePage.this.getAssociatedEditors());
                    EditorRegistry registry = (EditorRegistry)editorRegistry;
                    IContentType contentType = (IContentType)ContentTypesPreferencePage.this.editorAssociationsViewer.getInput();
                    if (dialog.open() == 0) {
                        registry.addUserAssociation(contentType, dialog.getSelectedEditor());
                        ContentTypesPreferencePage.this.editorAssociationsViewer.refresh();
                    }
                }
            }
        });
        Button removeEditorButton = new Button(buttonsComposite, 8);
        removeEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (editorRegistry instanceof EditorRegistry) {
                    EditorRegistry registry = (EditorRegistry)editorRegistry;
                    IEditorDescriptor editor = (IEditorDescriptor)ContentTypesPreferencePage.this.editorAssociationsViewer.getStructuredSelection().getFirstElement();
                    IContentType contentType = (IContentType)ContentTypesPreferencePage.this.editorAssociationsViewer.getInput();
                    registry.removeUserAssociation(contentType, editor);
                    ContentTypesPreferencePage.this.editorAssociationsViewer.refresh();
                }
            }
        });
        removeEditorButton.setText(WorkbenchMessages.ContentTypes_editorAssociationRemoveLabel);
        this.setButtonLayoutData(removeEditorButton);
        this.editorAssociationsViewer.addSelectionChangedListener(event -> {
            if (editorRegistry instanceof EditorRegistry) {
                EditorRegistry registry = (EditorRegistry)editorRegistry;
                IEditorDescriptor editor = (IEditorDescriptor)this.editorAssociationsViewer.getStructuredSelection().getFirstElement();
                IContentType contentType = (IContentType)this.editorAssociationsViewer.getInput();
                removeEditorButton.setEnabled(registry.isUserAssociation(contentType, editor));
            }
        });
        this.addEditorAssociationButton.setEnabled(this.editorAssociationsViewer.getInput() != null);
        removeEditorButton.setEnabled(this.editorAssociationsViewer.getInput() != null);
    }

    private void createCharset(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData compositeData = new GridData(768);
        composite.setLayoutData((Object)compositeData);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(parent.getFont());
        label.setText(WorkbenchMessages.ContentTypes_characterSetLabel);
        this.charsetField = new Text(composite, 2052);
        this.charsetField.setFont(parent.getFont());
        this.charsetField.setEnabled(false);
        GridData data = new GridData(768);
        this.charsetField.setLayoutData((Object)data);
        this.setButton = new Button(composite, 8);
        this.setButton.setFont(parent.getFont());
        this.setButton.setText(WorkbenchMessages.ContentTypes_characterSetUpdateLabel);
        this.setButton.setEnabled(false);
        this.setButtonLayoutData(this.setButton);
        this.setButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                String text = this.charsetField.getText().trim();
                if (text.length() == 0) {
                    text = null;
                }
                this.getSelectedContentType().setDefaultCharset(text);
                this.setButton.setEnabled(false);
            }
            catch (CoreException e1) {
                StatusUtil.handleStatus(e1.getStatus(), 2, parent.getShell());
            }
        }));
        this.charsetField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IContentType contentType = ContentTypesPreferencePage.this.getSelectedContentType();
                String charset = contentType.getDefaultCharset();
                if (charset == null) {
                    charset = "";
                }
                ContentTypesPreferencePage.this.setButton.setEnabled(!charset.equals(ContentTypesPreferencePage.this.charsetField.getText()) && ContentTypesPreferencePage.this.getErrorMessage() == null);
            }
        });
        this.charsetField.addModifyListener(e -> {
            String errorMessage = null;
            String text = this.charsetField.getText();
            try {
                if (text.length() != 0 && !Charset.isSupported(text)) {
                    errorMessage = WorkbenchMessages.ContentTypes_unsupportedEncoding;
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                errorMessage = WorkbenchMessages.ContentTypes_unsupportedEncoding;
            }
            this.setErrorMessage(errorMessage);
        });
    }

    private void createFileAssociations(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_fileAssociationsLabel);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fileAssociationViewer = new TableViewer(composite);
        this.fileAssociationViewer.setComparator((ViewerComparator)new FileSpecComparator());
        this.fileAssociationViewer.getControl().setFont(composite.getFont());
        this.fileAssociationViewer.setContentProvider((IContentProvider)new FileSpecContentProvider());
        this.fileAssociationViewer.setLabelProvider((IBaseLabelProvider)new FileSpecLabelProvider());
        data = new GridData(1808);
        this.fileAssociationViewer.getControl().setLayoutData((Object)data);
        this.fileAssociationViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            if (selection.isEmpty()) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                return;
            }
            boolean enabled = true;
            List elements = selection.toList();
            for (Spec spec : elements) {
                if (!spec.isPredefined) continue;
                enabled = false;
            }
            this.editButton.setEnabled(enabled && selection.size() == 1);
            this.removeButton.setEnabled(enabled);
        });
        Composite buttonArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        buttonArea.setLayout((Layout)layout);
        data = new GridData(-1, 128, false, false);
        buttonArea.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setFont(composite.getFont());
        this.addButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsAddLabel);
        this.addButton.setEnabled(false);
        this.setButtonLayoutData(this.addButton);
        this.addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Shell shell = composite.getShell();
            IContentType selectedContentType = this.getSelectedContentType();
            ContentTypeFilenameAssociationDialog dialog = new ContentTypeFilenameAssociationDialog(shell, WorkbenchMessages.ContentTypes_addDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_addDialog_messageHeader, WorkbenchMessages.ContentTypes_addDialog_message, WorkbenchMessages.ContentTypes_addDialog_label);
            if (dialog.open() == 0) {
                try {
                    try {
                        selectedContentType.addFileSpec(dialog.getSpecText(), dialog.getSpecType());
                    }
                    catch (CoreException ex) {
                        StatusUtil.handleStatus(ex.getStatus(), 2, shell);
                        WorkbenchPlugin.log(ex);
                        this.fileAssociationViewer.refresh(false);
                    }
                }
                finally {
                    this.fileAssociationViewer.refresh(false);
                }
            }
        }));
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setFont(composite.getFont());
        this.editButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsEditLabel);
        this.editButton.setEnabled(false);
        this.setButtonLayoutData(this.editButton);
        this.editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Shell shell = composite.getShell();
            IContentType selectedContentType = this.getSelectedContentType();
            Spec spec = this.getSelectedSpecs()[0];
            ContentTypeFilenameAssociationDialog dialog = new ContentTypeFilenameAssociationDialog(shell, WorkbenchMessages.ContentTypes_editDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_editDialog_messageHeader, WorkbenchMessages.ContentTypes_editDialog_message, WorkbenchMessages.ContentTypes_editDialog_label);
            dialog.setInitialValue(spec.toString());
            if (dialog.open() == 0) {
                try {
                    try {
                        selectedContentType.removeFileSpec(spec.text, spec.type);
                        selectedContentType.addFileSpec(dialog.getSpecText(), dialog.getSpecType());
                    }
                    catch (CoreException ex) {
                        StatusUtil.handleStatus(ex.getStatus(), 2, shell);
                        WorkbenchPlugin.log(ex);
                        this.fileAssociationViewer.refresh(false);
                    }
                }
                finally {
                    this.fileAssociationViewer.refresh(false);
                }
            }
        }));
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsRemoveLabel);
        this.setButtonLayoutData(this.removeButton);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            IContentType contentType = this.getSelectedContentType();
            Spec[] specs = this.getSelectedSpecs();
            MultiStatus result = new MultiStatus("org.eclipse.ui", 0, new IStatus[0], WorkbenchMessages.ContentTypes_errorDialogMessage, null);
            Spec[] specArray = specs;
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                Spec spec = specArray[n2];
                try {
                    contentType.removeFileSpec(spec.text, spec.type);
                }
                catch (CoreException e) {
                    result.add(e.getStatus());
                }
                ++n2;
            }
            if (!result.isOK()) {
                StatusUtil.handleStatus((IStatus)result, 2, composite.getShell());
            }
            this.fileAssociationViewer.refresh(false);
        }));
    }

    protected Spec[] getSelectedSpecs() {
        List list = this.fileAssociationViewer.getStructuredSelection().toList();
        return list.toArray(new Spec[list.size()]);
    }

    protected IContentType getSelectedContentType() {
        return (IContentType)this.contentTypesViewer.getStructuredSelection().getFirstElement();
    }

    private void createContentTypesTree(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_contentTypesLabel);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.contentTypesViewer = new TreeViewer(composite, 2820);
        this.contentTypesViewer.getControl().setFont(composite.getFont());
        this.contentTypesViewer.setContentProvider((IContentProvider)new ContentTypesContentProvider());
        this.contentTypesViewer.setLabelProvider((IBaseLabelProvider)new ContentTypesLabelProvider());
        this.contentTypesViewer.setComparator(new ViewerComparator());
        this.contentTypesViewer.setInput((Object)Platform.getContentTypeManager());
        data = new GridData(1808);
        this.contentTypesViewer.getControl().setLayoutData((Object)data);
        this.contentTypesViewer.addSelectionChangedListener(event -> {
            IContentType contentType = (IContentType)event.getStructuredSelection().getFirstElement();
            this.fileAssociationViewer.setInput((Object)contentType);
            this.editorAssociationsViewer.setInput((Object)contentType);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            if (contentType != null) {
                String charset = contentType.getDefaultCharset();
                if (charset == null) {
                    charset = "";
                }
                this.charsetField.setText(charset);
            } else {
                this.charsetField.setText("");
            }
            this.charsetField.setEnabled(contentType != null);
            this.addEditorAssociationButton.setEnabled(contentType != null);
            this.addButton.setEnabled(contentType != null);
            this.setButton.setEnabled(false);
            this.addChildContentTypeButton.setEnabled(contentType != null);
            this.removeContentTypeButton.setEnabled(contentType != null && contentType.isUserDefined());
        });
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(-1, 128, false, false));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        Button addRootContentTypeButton = new Button(buttonsComposite, 8);
        addRootContentTypeButton.setText(WorkbenchMessages.ContentTypes_addRootContentTypeButton);
        this.setButtonLayoutData(addRootContentTypeButton);
        addRootContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String id = "userCreated" + System.currentTimeMillis();
            IContentTypeManager manager = (IContentTypeManager)this.contentTypesViewer.getInput();
            NewContentTypeDialog dialog = new NewContentTypeDialog(this.getShell(), manager, null);
            if (dialog.open() == 0) {
                try {
                    IContentType newContentType = manager.addContentType(id, dialog.getName(), null);
                    this.contentTypesViewer.refresh();
                    this.contentTypesViewer.setSelection((ISelection)new StructuredSelection((Object)newContentType));
                }
                catch (CoreException e1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
                }
            }
        }));
        this.addChildContentTypeButton = new Button(buttonsComposite, 8);
        this.addChildContentTypeButton.setText(WorkbenchMessages.ContentTypes_addChildContentTypeButton);
        this.setButtonLayoutData(this.addChildContentTypeButton);
        this.addChildContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String id = "userCreated" + System.currentTimeMillis();
            IContentTypeManager manager = (IContentTypeManager)this.contentTypesViewer.getInput();
            NewContentTypeDialog dialog = new NewContentTypeDialog(this.getShell(), manager, this.getSelectedContentType());
            if (dialog.open() == 0) {
                try {
                    IContentType newContentType = manager.addContentType(id, dialog.getName(), this.getSelectedContentType());
                    this.contentTypesViewer.refresh((Object)this.getSelectedContentType());
                    this.contentTypesViewer.setSelection((ISelection)new StructuredSelection((Object)newContentType));
                }
                catch (CoreException e1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
                }
            }
        }));
        this.addChildContentTypeButton.setEnabled(this.getSelectedContentType() != null);
        this.removeContentTypeButton = new Button(buttonsComposite, 8);
        this.removeContentTypeButton.setText(WorkbenchMessages.ContentTypes_removeContentTypeButton);
        this.setButtonLayoutData(this.removeContentTypeButton);
        this.removeContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IContentType selectedContentType = this.getSelectedContentType();
            try {
                Platform.getContentTypeManager().removeContentType(selectedContentType.getId());
                this.contentTypesViewer.refresh();
            }
            catch (CoreException e1) {
                MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
            }
        }));
        this.removeContentTypeButton.setEnabled(this.getSelectedContentType() != null && this.getSelectedContentType().isUserDefined());
    }

    @Override
    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.noDefaultAndApplyButton();
    }

    public void dispose() {
        super.dispose();
        this.disposableEditorIcons.forEach(Resource::dispose);
    }

    private class ContentTypesContentProvider
    implements ITreeContentProvider {
        private IContentTypeManager manager;

        private ContentTypesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<IContentType> elements = new ArrayList<IContentType>();
            IContentType baseType = (IContentType)parentElement;
            IContentType[] iContentTypeArray = this.manager.getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType contentType = iContentTypeArray[n2];
                if (Objects.equals(contentType.getBaseType(), baseType)) {
                    elements.add(contentType);
                }
                ++n2;
            }
            return elements.toArray(new IContentType[0]);
        }

        public Object getParent(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getBaseType();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.manager = (IContentTypeManager)newInput;
        }
    }

    private class ContentTypesLabelProvider
    extends LabelProvider {
        private ContentTypesLabelProvider() {
        }

        public String getText(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getName();
        }
    }

    private class FileSpecComparator
    extends ViewerComparator {
        private FileSpecComparator() {
        }

        public int category(Object element) {
            return ((Spec)element).sortValue;
        }
    }

    private class FileSpecContentProvider
    implements IStructuredContentProvider {
        private FileSpecContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IContentType contentType = (IContentType)inputElement;
            String[] userextfileSpecs = contentType.getFileSpecs(9);
            String[] usernamefileSpecs = contentType.getFileSpecs(5);
            String[] preextfileSpecs = contentType.getFileSpecs(10);
            String[] prenamefileSpecs = contentType.getFileSpecs(6);
            String[] userPatternFileSpecs = contentType.getFileSpecs(17);
            String[] prePatternFileSpecs = contentType.getFileSpecs(18);
            return this.createSpecs(userextfileSpecs, usernamefileSpecs, userPatternFileSpecs, preextfileSpecs, prenamefileSpecs, prePatternFileSpecs);
        }

        private Spec[] createSpecs(String[] userextfileSpecs, String[] usernamefileSpecs, String[] userPatternFileSpecs, String[] preextfileSpecs, String[] prenamefileSpecs, String[] prePatternFileSpecs) {
            Spec spec;
            ArrayList<Spec> returnValues = new ArrayList<Spec>();
            String[] stringArray = usernamefileSpecs;
            int n = usernamefileSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                String usernamefileSpec = stringArray[n2];
                spec = new Spec(usernamefileSpec, 4, false, 0);
                returnValues.add(spec);
                ++n2;
            }
            stringArray = prenamefileSpecs;
            n = prenamefileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String prenamefileSpec = stringArray[n2];
                spec = new Spec(prenamefileSpec, 4, true, 1);
                returnValues.add(spec);
                ++n2;
            }
            stringArray = userextfileSpecs;
            n = userextfileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String userextfileSpec = stringArray[n2];
                spec = new Spec(userextfileSpec, 8, false, 2);
                returnValues.add(spec);
                ++n2;
            }
            stringArray = preextfileSpecs;
            n = preextfileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String preextfileSpec = stringArray[n2];
                spec = new Spec(preextfileSpec, 8, true, 3);
                returnValues.add(spec);
                ++n2;
            }
            stringArray = userPatternFileSpecs;
            n = userPatternFileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String userPatternFileSpec = stringArray[n2];
                spec = new Spec(userPatternFileSpec, 16, false, 4);
                returnValues.add(spec);
                ++n2;
            }
            stringArray = prePatternFileSpecs;
            n = prePatternFileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String prePatternFileSpec = stringArray[n2];
                spec = new Spec(prePatternFileSpec, 16, true, 5);
                returnValues.add(spec);
                ++n2;
            }
            return returnValues.toArray(new Spec[returnValues.size()]);
        }
    }

    private class FileSpecLabelProvider
    extends LabelProvider {
        private FileSpecLabelProvider() {
        }

        public String getText(Object element) {
            String label = super.getText(element);
            return TextProcessor.process((String)label, (String)"*.");
        }

        public Image getImage(Object element) {
            Spec spec = (Spec)element;
            if (spec.getPredefined()) {
                return JFaceResources.getImage((String)"LOCKED_JOB");
            }
            return null;
        }
    }

    private static class Spec {
        final String text;
        final int type;
        final boolean isPredefined;
        final int sortValue;

        public Spec(String specText, int specType, boolean isPredefined, int sortValue) {
            if (specType != 4 && specType != 8 && specType != 16) {
                throw new IllegalArgumentException("Invalid specType");
            }
            this.type = specType;
            this.text = specText;
            this.isPredefined = isPredefined;
            this.sortValue = sortValue;
        }

        public String toString() {
            if (this.type == 8) {
                return "*." + this.text;
            }
            return this.text;
        }

        public boolean getPredefined() {
            return this.isPredefined;
        }
    }
}

