/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.config;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikitextEditorBuild;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.docmlet.wikitext.ui.config.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettings;
import org.eclipse.statet.ltk.ui.sourceediting.SmartInsertSettingsUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class WikitextEditorConfigurationBlock
extends ManagedConfigurationBlock {
    private Button smartInsertControl;
    private ComboViewer smartInsertTabActionControl;
    private Button smartInsertCloseBracketsControl;
    private Button smartInsertCloseParenthesisControl;
    private Button smartInsertCloseMathDollarControl;
    private Button smartInsertHardWrapTextControl;
    private Button foldingEnableControl;
    private Button foldingRestoreStateControl;
    private Button markOccurrencesControl;
    private Button problemsEnableControl;

    public WikitextEditorConfigurationBlock(@Nullable StatusChangeListener statusListener) {
        super(null, statusListener);
    }

    public void createBlockArea(Composite pageComposite) {
        HashMap<Object, @Nullable String> prefs = new HashMap<Object, String>();
        prefs.put(WikitextEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_TAB_ACTION_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_CLOSEBRACKETS_ENABLED_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_CLOSEPARENTHESIS_ENABLED_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_CLOSEMATHDOLLAR_ENABLED_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_HARDWRAP_TEXT_ENABLED_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.SMARTINSERT_HARDWRAP_MODE_PREF, "Wikitext/editor/smartinsert");
        prefs.put(WikitextEditingSettings.FOLDING_ENABLED_PREF, null);
        prefs.put(WikitextEditingSettings.FOLDING_RESTORE_STATE_ENABLED_PREF, "Wikitext/editor/folding.shared");
        prefs.put(WikitextEditingSettings.MARKOCCURRENCES_ENABLED_PREF, null);
        prefs.put(WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF, null);
        this.setupPreferenceManager(prefs);
        Composite composite = this.createSmartInsertOptions(pageComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        this.foldingEnableControl = new Button(pageComposite, 32);
        this.foldingEnableControl.setText(Messages.EditorOptions_Folding_Enable_label);
        this.foldingEnableControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.foldingRestoreStateControl = new Button(pageComposite, 32);
        this.foldingRestoreStateControl.setText(Messages.EditorOptions_Folding_RestoreState_Enable_label);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        this.foldingRestoreStateControl.setLayoutData((Object)gd);
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        this.markOccurrencesControl = new Button(pageComposite, 32);
        this.markOccurrencesControl.setText(Messages.EditorOptions_MarkOccurrences_Enable_label);
        this.markOccurrencesControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        this.problemsEnableControl = new Button(pageComposite, 32);
        this.problemsEnableControl.setText(Messages.EditorOptions_ProblemChecking_Enable_label);
        this.problemsEnableControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)true);
        Link link = this.addLinkControl(pageComposite, Messages.EditorOptions_AnnotationAppearance_info);
        GridData gd2 = new GridData(4, 128, true, false);
        gd2.widthHint = 300;
        link.setLayoutData((Object)gd2);
        LayoutUtils.addSmallFiller((Composite)pageComposite, (boolean)false);
        this.initBindings();
        this.updateControls();
    }

    private Composite createSmartInsertOptions(Composite pageComposite) {
        Group composite = new Group(pageComposite, 0);
        composite.setText(String.valueOf(Messages.EditorOptions_SmartInsert_label) + ':');
        int n = 4;
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        this.smartInsertControl = new Button((Composite)composite, 32);
        this.smartInsertControl.setText(Messages.EditorOptions_SmartInsert_AsDefault_label);
        this.smartInsertControl.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Link link = this.addLinkControl((Composite)composite, Messages.EditorOptions_SmartInsert_description);
        GridData gd = new GridData(4, 4, true, false, 4, 1);
        gd.widthHint = 300;
        link.setLayoutData((Object)gd);
        Label label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.EditorOptions_SmartInsert_TabAction_label);
        this.smartInsertTabActionControl = new ComboViewer((Composite)composite, 12);
        this.smartInsertTabActionControl.getControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.smartInsertTabActionControl.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.smartInsertTabActionControl.setLabelProvider((IBaseLabelProvider)new SmartInsertSettingsUI.SettingsLabelProvider());
        this.smartInsertTabActionControl.setInput((Object)new SmartInsertSettings.TabAction[]{SmartInsertSettings.TabAction.INSERT_TAB_CHAR, SmartInsertSettings.TabAction.INSERT_TAB_LEVEL, SmartInsertSettings.TabAction.INSERT_INDENT_LEVEL, SmartInsertSettings.TabAction.CORRECT_INDENT});
        LayoutUtils.addGDDummy((Composite)composite);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)true);
        this.smartInsertCloseBracketsControl = this.createSmartInsertOption((Composite)composite, Messages.EditorOptions_SmartInsert_CloseAuto_label, Messages.EditorOptions_SmartInsert_CloseBrackets_label, true);
        Label dummy = new Label((Composite)composite, 0);
        dummy.setVisible(false);
        dummy.setLayoutData((Object)new GridData(4, 128, true, false, 1, 4));
        this.smartInsertCloseParenthesisControl = this.createSmartInsertOption((Composite)composite, null, Messages.EditorOptions_SmartInsert_CloseParentheses_label, true);
        this.smartInsertCloseMathDollarControl = this.createSmartInsertOption((Composite)composite, null, Messages.EditorOptions_SmartInsert_CloseMathDollar_label, true);
        this.smartInsertHardWrapTextControl = this.createSmartInsertOption((Composite)composite, Messages.EditorOptions_SmartInsert_HardWrapAuto_label, Messages.EditorOptions_SmartInsert_HardWrapText_label, true);
        return composite;
    }

    private Button createSmartInsertOption(Composite composite, @Nullable String text1, @Nullable String text2, boolean console) {
        GridData gd;
        Label label;
        if (text1 != null) {
            label = new Label(composite, 0);
            if (text2 == null) {
                label.setText(String.valueOf(text1) + "\u200a:");
                gd = new GridData(4, 0x1000000, false, false, 2, 1);
            } else {
                label.setText(text1);
                gd = new GridData(4, 0x1000000, false, false, 1, 1);
            }
            label.setLayoutData((Object)gd);
        } else {
            LayoutUtils.addGDDummy((Composite)composite);
        }
        if (text2 != null) {
            label = new Label(composite, 0);
            label.setText(String.valueOf(text2) + ':');
            gd = new GridData(4, 0x1000000, false, false, 1, 1);
            label.setLayoutData((Object)gd);
        }
        Button button = new Button(composite, 32);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.smartInsertControl), this.createObservable(WikitextEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)ViewerProperties.singleSelection(SmartInsertSettings.TabAction.class).observe((Viewer)this.smartInsertTabActionControl), this.createObservable((Preference)WikitextEditingSettings.SMARTINSERT_TAB_ACTION_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.smartInsertCloseBracketsControl), this.createObservable(WikitextEditingSettings.SMARTINSERT_CLOSEBRACKETS_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.smartInsertCloseParenthesisControl), this.createObservable(WikitextEditingSettings.SMARTINSERT_CLOSEPARENTHESIS_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.smartInsertCloseMathDollarControl), this.createObservable(WikitextEditingSettings.SMARTINSERT_CLOSEMATHDOLLAR_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.smartInsertHardWrapTextControl), this.createObservable(WikitextEditingSettings.SMARTINSERT_HARDWRAP_TEXT_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.foldingEnableControl), this.createObservable((Preference)WikitextEditingSettings.FOLDING_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.foldingRestoreStateControl), this.createObservable((Preference)WikitextEditingSettings.FOLDING_RESTORE_STATE_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.markOccurrencesControl), this.createObservable((Preference)WikitextEditingSettings.MARKOCCURRENCES_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.problemsEnableControl), this.createObservable((Preference)WikitextEditorBuild.PROBLEMCHECKING_ENABLED_PREF));
    }
}

