/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.config;

import java.util.HashMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.ui.ColorSelectorObservableValue;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.preferences.ui.PreferenceUIUtils;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.docmlet.wikitext.ui.config.Messages;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.EmbeddedHtml;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

@NonNullByDefault
class WikitextBaseConfigurationBlock
extends ManagedConfigurationBlock {
    private ColorSelector htmlBackgroundColorSelector = (ColorSelector)ObjectUtils.nonNullLateInit();
    private ColorSelector htmlCommentColorSelector = (ColorSelector)ObjectUtils.nonNullLateInit();

    public WikitextBaseConfigurationBlock(StatusChangeListener statusListener) {
        super(null, statusListener);
    }

    public void createBlockArea(Composite pageComposite) {
        HashMap<Preference<RGB>, Object> prefs = new HashMap<Preference<RGB>, Object>();
        prefs.put(EmbeddedHtml.HTML_BACKGROUND_COLOR_PREF, null);
        prefs.put(EmbeddedHtml.HTML_COMMENT_COLOR_PREF, null);
        this.setupPreferenceManager(prefs);
        Composite composite = this.createEditorGroup(pageComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initBindings();
        this.updateControls();
    }

    private Composite createEditorGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText(String.valueOf(Messages.Base_Editors_label) + ':');
        Link link = this.addLinkControl((Composite)composite, PreferenceUIUtils.composeSeeAlsoPreferencePages().add("All <a>Text Editors</a> in Eclipse", new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor+"}).add("All <a>Source Editors of StatET</a>", new String[]{"org.eclipse.statet.ltk.preferencePages.SourceEditors"}).add("<a>Wikitext Syntax Hightlighting</a> (Mylyn)", new String[]{"org.eclipse.mylyn.wikitext.ui.editor.preferences.EditorPreferencePage"}).add("<a>Wikitext User Templates</a> (Mylyn)", new String[]{"org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.WikiTextTemplatePreferencePage"}).toString());
        GridData gd = new GridData(4, 4, true, false, 2, 1);
        WikitextBaseConfigurationBlock.applyWrapWidth((GridData)gd);
        link.setLayoutData((Object)gd);
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        Label label = new Label((Composite)composite, 0);
        label.setText("Supplementary preferences:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label((Composite)composite, 0);
        label.setText("Background color for &HTML ranges:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ColorSelector selector = new ColorSelector((Composite)composite);
        selector.getButton().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.htmlBackgroundColorSelector = selector;
        label = new Label((Composite)composite, 0);
        label.setText("Text color for HTML c&omments:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        selector = new ColorSelector((Composite)composite);
        selector.getButton().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.htmlCommentColorSelector = selector;
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)new ColorSelectorObservableValue(this.htmlBackgroundColorSelector), this.createObservable(EmbeddedHtml.HTML_BACKGROUND_COLOR_PREF), null, null);
        db.getContext().bindValue((IObservableValue)new ColorSelectorObservableValue(this.htmlCommentColorSelector), this.createObservable(EmbeddedHtml.HTML_COMMENT_COLOR_PREF), null, null);
    }
}

