/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class UnterminatedLaunchAlerter
implements IWorkbenchListener {
    private static Object gMutex = new Object();
    private static UnterminatedLaunchAlerter gInstance;
    private final Set<String> fLauchTypeIds = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLaunchType(String id) {
        Object object = gMutex;
        synchronized (object) {
            if (gInstance == null) {
                gInstance = new UnterminatedLaunchAlerter();
            }
            UnterminatedLaunchAlerter.gInstance.fLauchTypeIds.add(id);
        }
    }

    private UnterminatedLaunchAlerter() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        ILaunch[] launches;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        LinkedList<ILaunchConfigurationType> programTypes = new LinkedList<ILaunchConfigurationType>();
        Object object = gMutex;
        synchronized (object) {
            for (String id : this.fLauchTypeIds) {
                ILaunchConfigurationType programType = manager.getLaunchConfigurationType(id);
                if (programType == null) continue;
                programTypes.add(programType);
            }
        }
        if (programTypes.isEmpty()) {
            return true;
        }
        HashSet<ILaunchConfigurationType> stillRunningTypes = new HashSet<ILaunchConfigurationType>();
        int count = 0;
        ILaunch[] iLaunchArray = launches = manager.getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                ILaunchConfigurationType configType;
                ILaunch launch = iLaunchArray[n2];
                try {
                    ILaunchConfiguration config = launch.getLaunchConfiguration();
                    if (config == null) break block12;
                    configType = config.getType();
                }
                catch (CoreException e) {
                    break block12;
                }
                if (programTypes.contains(configType) && !launch.isTerminated()) {
                    ++count;
                    stillRunningTypes.add(configType);
                }
            }
            ++n2;
        }
        if (stillRunningTypes.isEmpty()) {
            return true;
        }
        StringBuilder names = new StringBuilder(stillRunningTypes.size() * 20);
        names.append('\n');
        for (ILaunchConfigurationType type : stillRunningTypes) {
            names.append("- ");
            names.append(type.getName());
            names.append('\n');
        }
        String message = NLS.bind((String)Messages.UnterminatedLaunchAlerter_WorkbenchClosing_message, (Object[])new Object[]{count, names});
        if (forced) {
            MessageDialog.openWarning((Shell)UIAccess.getDisplay().getActiveShell(), (String)Messages.UnterminatedLaunchAlerter_WorkbenchClosing_title, (String)message);
            return true;
        }
        MessageDialog dialog = new MessageDialog(UIAccess.getDisplay().getActiveShell(), Messages.UnterminatedLaunchAlerter_WorkbenchClosing_title, null, message, 4, new String[]{Messages.UnterminatedLaunchAlerter_WorkbenchClosing_button_Continue, Messages.UnterminatedLaunchAlerter_WorkbenchClosing_button_Cancel}, 1);
        int answer = dialog.open();
        return answer != 1;
    }

    public void postShutdown(IWorkbench workbench) {
    }
}

