/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.ArrayList;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.ui.actions.LtxOpenDeclarationHandler;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.OpenTexElementHyperlink;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;

@NonNullByDefault
public class TexElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public @NonNull IHyperlink @Nullable [] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        SourceEditor editor = (SourceEditor)this.getAdapter(SourceEditor.class);
        if (editor == null) {
            return null;
        }
        ArrayList<OpenTexElementHyperlink> hyperlinks = new ArrayList<OpenTexElementHyperlink>(4);
        TexNameAccess access = LtxOpenDeclarationHandler.searchAccess(editor, (TextRegion)JFaceTextRegion.toTextRegion((IRegion)region));
        if (access != null) {
            hyperlinks.add(new OpenTexElementHyperlink(editor, (TexSourceUnit)editor.getSourceUnit(), access));
        }
        if (!hyperlinks.isEmpty()) {
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        return null;
    }
}

