/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractSourceEditorHandler;

@NonNullByDefault
public class MultiContentSectionHandler
extends AbstractSourceEditorHandler {
    private static final IHandler2 NULL = new AbstractHandler(){

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            return null;
        }
    };
    private final DocContentSections sections;
    private final Map<String, IHandler2> handlers = new IdentityHashMap<String, IHandler2>(8);

    public MultiContentSectionHandler(DocContentSections sections) {
        this.sections = (DocContentSections)ObjectUtils.nonNullAssert((Object)sections);
    }

    public MultiContentSectionHandler(DocContentSections sections, String sectionType1, IHandler2 handler1) {
        this(sections, sectionType1, handler1, null, null);
    }

    public MultiContentSectionHandler(DocContentSections sections, @Nullable String sectionType1, @Nullable IHandler2 handler1, @Nullable String sectionType2, @Nullable IHandler2 handler2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerHandler(sectionType1, handler1);
        }
        if (sectionType2 != null) {
            this.registerHandler(sectionType2, handler2);
        }
    }

    protected final DocContentSections getSections() {
        return this.sections;
    }

    public void dispose() {
        super.dispose();
        for (IHandler2 handler : this.handlers.values()) {
            if (handler == NULL) continue;
            handler.dispose();
        }
        this.handlers.clear();
    }

    public void registerHandler(String sectionType, @Nullable IHandler2 handler) {
        this.handlers.put((String)ObjectUtils.nonNullAssert((Object)sectionType), (IHandler2)ObjectUtils.nonNullElse((Object)handler, (Object)NULL));
    }

    protected final @Nullable IHandler2 getHandler(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        IHandler2 handler = this.handlers.get(sectionType);
        if (handler == null) {
            try {
                handler = this.createHandler(sectionType);
            }
            finally {
                this.registerHandler(sectionType, handler);
            }
        }
        return handler != NULL ? handler : null;
    }

    protected @Nullable IHandler2 createHandler(String sectionType) {
        return null;
    }

    @Override
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        SourceEditor editor = this.getSourceEditor(event.getApplicationContext());
        if (editor == null || !this.isSupported(editor)) {
            return null;
        }
        SourceViewer viewer = editor.getViewer();
        IHandler2 handler = this.getHandler(this.sections.getType((IDocument)ObjectUtils.nonNullAssert((Object)viewer.getDocument()), viewer.getSelectedRange().x));
        if (handler != null) {
            return handler.execute(event);
        }
        return null;
    }
}

