/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.internal.ltk.ui.LtkUIPlugin;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.FontData;

@NonNullByDefault
public class DefaultBrowserInformationInput
extends BrowserInformationControlInput {
    public static final int FORMAT_NONE = 0;
    public static final int FORMAT_TEXT_INPUT = 1;
    public static final int FORMAT_SOURCE_INPUT = 2;
    public static final int FORMAT_HTMLBODY_INPUT = 3;
    public static final int FORMAT_HTMLSOURCE_INPUT = 4;
    private static @Nullable Formatter FORMATTER;
    private final String name;
    private final String html;

    public DefaultBrowserInformationInput(String name, String content, int formatting, int tabSize, @Nullable BrowserInformationControlInput previous) {
        super(previous);
        this.name = (String)ObjectUtils.nonNullAssert((Object)name);
        this.html = this.getFormatter().format((String)ObjectUtils.nonNullAssert((Object)content), formatting, tabSize);
    }

    public DefaultBrowserInformationInput(String name, String content, int formatting, @Nullable BrowserInformationControlInput previous) {
        this(name, content, formatting, 4, previous);
    }

    public DefaultBrowserInformationInput(String name, String content, int formatting, int tabSize) {
        this(name, content, formatting, tabSize, null);
    }

    public DefaultBrowserInformationInput(String name, String content, int formatting) {
        this(name, content, formatting, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Formatter getFormatter() {
        Class<DefaultBrowserInformationInput> clazz = DefaultBrowserInformationInput.class;
        synchronized (DefaultBrowserInformationInput.class) {
            Formatter formatter = FORMATTER;
            if (formatter == null) {
                FORMATTER = formatter = new Formatter();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return formatter;
        }
    }

    public String getInputName() {
        return this.name;
    }

    public Object getInputElement() {
        return this.html;
    }

    public String getHtml() {
        return this.html;
    }

    private static class Formatter
    implements IPropertyChangeListener,
    Disposable {
        private String stylesheet = (String)ObjectUtils.nonNullLateInit();

        public Formatter() {
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            LtkUIPlugin.getInstance().addStoppingListener(this);
            this.updateStyleSheet();
        }

        public void dispose() {
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
            FORMATTER = null;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                this.updateStyleSheet();
            }
        }

        private void updateStyleSheet() {
            String style = "html        { font-family: sans-serif; font-size: 9pt; font-style: normal; font-weight: normal; }\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt { font-size: 1em; }\npre         { font-family: monospace; }\nhtml        { margin: 0px; padding: 0px }body        { overflow: auto; margin-top: 0.25em; margin-bottom: 0.5em; margin-left: 0.25em; margin-right: 0.25em; }\nh1          { margin-top: 0.3em; margin-bottom: 0.04em; }\nh2          { margin-top: 2em; margin-bottom: 0.25em; }\nh3          { margin-top: 1.7em; margin-bottom: 0.25em; }\nh4          { margin-top: 2em; margin-bottom: 0.3em; }\nh5          { margin-top: 0px; margin-bottom: 0px; }\np           { margin-top: 1em; margin-bottom: 1em; }\nul          { margin-top: 0px; margin-bottom: 1em; }\nli          { margin-top: 0px; margin-bottom: 0px; }\nli p        { margin-top: 0px; margin-bottom: 0px; }\nol          { margin-top: 0px; margin-bottom: 1em; }\ndl          { margin-top: 0px; margin-bottom: 1em; }\ndt          { margin-top: 0px; margin-bottom: 0px; font-weight: bold; }\ndd          { margin-top: 0px; margin-bottom: 0px; }\na:link      { color: #0000FF; }\na:hover     { color: #000080; }\na:visited   { text-decoration: underline; }\nh4          { font-style: italic; }\nstrong      { font-weight: bold; }\nem          { font-style: italic; }\nvar         { font-style: italic; }\nth          { font-weight: bold; }\n";
            try {
                FontData[] fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont");
                if (fontData != null && fontData.length > 0) {
                    style = style.replace("9pt", String.valueOf(fontData[0].getHeight()) + "pt");
                    style = style.replace("sans-serif", "sans-serif, '" + fontData[0].getName() + "'");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stylesheet = style;
        }

        String format(String content, int formatting, int tabSize) {
            StringBuilder sb;
            String stylesheet = this.stylesheet;
            switch (formatting) {
                case 0: {
                    return content;
                }
                case 1: {
                    content = HTMLPrinter.convertToHTMLContent((String)content);
                    sb = new StringBuilder(content.length() + stylesheet.length() + 500);
                    sb.append(content);
                    break;
                }
                case 3: {
                    sb = new StringBuilder(content.length() + stylesheet.length() + 500);
                    sb.append(content);
                    break;
                }
                case 2: {
                    content = HTMLPrinter.convertToHTMLContent((String)content);
                }
                case 4: {
                    int tabIdx;
                    sb = new StringBuilder((int)((double)content.length() * 1.066) + stylesheet.length() + 500);
                    sb.append("<pre>");
                    String spaces = " ".repeat(tabSize);
                    int fromIdx = 0;
                    while ((tabIdx = content.indexOf(9, fromIdx)) >= 0) {
                        sb.append(content, fromIdx, tabIdx);
                        sb.append(spaces);
                        fromIdx = tabIdx + 1;
                    }
                    sb.append(content, fromIdx, content.length());
                    sb.append("</pre>");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported format");
                }
            }
            HTMLPrinter.insertPageProlog((StringBuilder)sb, (int)0, (String)this.stylesheet);
            HTMLPrinter.addPageEpilog((StringBuilder)sb);
            return sb.toString();
        }
    }
}

