/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.core.source;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RweaveDocSectionTreePartImpl {
    private final DocContentSections sections;

    public RweaveDocSectionTreePartImpl(DocContentSections sections) {
        this.sections = sections;
    }

    public DocContentSections getSections() {
        return this.sections;
    }

    public @Nullable TreePartitionNode getRChunkRegion(IDocument document, int offset) throws BadLocationException {
        return TreePartitionUtils.searchNode((IDocument)document, (String)this.sections.getPartitioning(), (int)offset, (boolean)false, (String)"RweaveChunk.Base");
    }

    public List<TreePartitionNode> getRChunkRegions(IDocument document, int offset, int length) throws BadLocationException {
        ArrayList<TreePartitionNode> nodes = new ArrayList<TreePartitionNode>();
        TreePartitionNode root = TreePartitionUtils.getRootNode((IDocument)document, (String)this.sections.getPartitioning());
        this.addRChunkRegions(root, offset, offset + length, nodes);
        return nodes;
    }

    private void addRChunkRegions(TreePartitionNode node, int startOffset, int endOffset, List<TreePartitionNode> nodes) {
        TreePartitionNode child;
        int childCount = node.getChildCount();
        int childIdx = 0;
        while (childIdx < childCount) {
            child = node.getChild(childIdx);
            if (child.getEndOffset() > startOffset) break;
            ++childIdx;
        }
        while (childIdx < childCount) {
            child = node.getChild(childIdx);
            if (child.getStartOffset() >= endOffset) break;
            if (child.getType().getPartitionType() == "RweaveChunk.Base") {
                nodes.add(child);
            } else {
                this.addRChunkRegions(child, startOffset, endOffset, nodes);
            }
            ++childIdx;
        }
    }

    public @Nullable IRegion getRChunkContentRegion(IDocument document, int offset) throws BadLocationException {
        TreePartitionNode rChunk = this.getRChunkRegion(document, offset);
        if (rChunk == null || rChunk.getLength() <= 2) {
            return null;
        }
        int beginLine = document.getLineOfOffset(rChunk.getStartOffset()) + 1;
        int beginLineOffset = document.getLineOffset(beginLine);
        int endLine = document.getLineOfOffset(rChunk.getEndOffset());
        if (beginLine >= endLine) {
            return null;
        }
        int endLineOffset = document.getLineOffset(endLine);
        if (endLineOffset == rChunk.getEndOffset()) {
            if (beginLine >= --endLine) {
                return null;
            }
            endLineOffset = document.getLineOffset(endLine);
        }
        if (document.getChar(endLineOffset) == '@') {
            return new Region(beginLineOffset, endLineOffset - beginLineOffset);
        }
        return new Region(beginLineOffset, rChunk.getEndOffset() - beginLineOffset);
    }

    public List<TreePartitionNode> getRChunkCodeRegions(IDocument document, int offset, int length) throws BadLocationException {
        List<TreePartitionNode> rChunks = this.getRChunkRegions(document, offset, length);
        ArrayList<TreePartitionNode> nodes = new ArrayList<TreePartitionNode>(rChunks.size());
        int endOffset = offset + length;
        int i = 0;
        while (i < rChunks.size()) {
            TreePartitionNode child;
            TreePartitionNode node = rChunks.get(i);
            int childCount = node.getChildCount();
            int childIdx = 0;
            while (childIdx < childCount) {
                child = node.getChild(childIdx);
                if (child.getEndOffset() > offset) break;
                ++childIdx;
            }
            while (childIdx < childCount) {
                child = node.getChild(childIdx);
                if (child.getStartOffset() >= endOffset) break;
                if (child.getType().getPartitionType() == "R.Default") {
                    nodes.add(child);
                }
                ++childIdx;
            }
            ++i;
        }
        return nodes;
    }

    public @Nullable TreePartitionNode getRCodeRegion(IDocument document, int offset) throws BadLocationException {
        return TreePartitionUtils.searchNode((IDocument)document, (String)this.sections.getPartitioning(), (int)offset, (boolean)true, (String)"R.Default");
    }
}

