/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.core.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

@NonNullByDefault
public class RChunkNode
implements AstNode {
    private static final ImList<Object> NO_ATTACHMENT = ImCollections.emptyList();
    private final AstNode parent;
    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Args weaveArgs;
    ImList<SourceComponent> rSources;
    int startOffset;
    int endOffset;
    private volatile ImList<Object> attachments = NO_ATTACHMENT;

    RChunkNode(AstNode parent) {
        this.parent = parent;
    }

    public int getStatusCode() {
        return 0;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Args getWeaveArgsChild() {
        return this.weaveArgs;
    }

    public ImList<SourceComponent> getRCodeChildren() {
        return this.rSources;
    }

    public int getChildCount() {
        if (this.weaveArgs != null) {
            return this.rSources.size() + 1;
        }
        return this.rSources.size();
    }

    public AstNode getChild(int index) {
        FCall.Args weaveArgs = this.weaveArgs;
        if (weaveArgs != null) {
            if (index == 0) {
                return weaveArgs;
            }
            return (AstNode)this.rSources.get(index - 1);
        }
        return (AstNode)this.rSources.get(index);
    }

    public int getChildIndex(AstNode element) {
        FCall.Args weaveArgs = this.weaveArgs;
        if (weaveArgs != null) {
            if (weaveArgs == element) {
                return 0;
            }
            int i = 0;
            while (i < this.rSources.size()) {
                if (this.rSources.get(i) == element) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < this.rSources.size()) {
            if (this.rSources.get(i) == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void accept(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this);
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        FCall.Args weaveArgs = this.weaveArgs;
        if (weaveArgs != null) {
            visitor.visit((AstNode)weaveArgs);
        }
        for (SourceComponent node : this.rSources) {
            visitor.visit((AstNode)node);
        }
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public synchronized void addAttachment(Object data) {
        this.attachments = ImCollections.addElement(this.attachments, (Object)data);
    }

    public synchronized void removeAttachment(Object data) {
        this.attachments = ImCollections.removeElement(this.attachments, (Object)data);
    }

    public ImList<Object> getAttachments() {
        return this.attachments;
    }
}

