/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;

@NonNullByDefault
public interface TextRegion {
    public int getStartOffset();

    public int getEndOffset();

    public int getLength();

    default public boolean isEmpty() {
        return this.getLength() == 0;
    }

    default public boolean contains(int offset) {
        return offset >= this.getStartOffset() && offset < this.getEndOffset();
    }

    default public boolean contains(TextRegion region) {
        return region.getStartOffset() >= this.getStartOffset() && region.getEndOffset() <= this.getEndOffset();
    }

    default public TextRegion expansion(TextRegion region) {
        int thisStartOffset = this.getStartOffset();
        int thisEndOffset = this.getEndOffset();
        int startOffset = Math.min(thisStartOffset, region.getStartOffset());
        int endOffset = Math.max(thisEndOffset, region.getEndOffset());
        return startOffset == thisStartOffset && endOffset == thisEndOffset ? this : new BasicTextRegion(startOffset, endOffset);
    }

    default public boolean intersectsNonEmpty(TextRegion region) {
        int endOffset;
        int startOffset = Math.max(this.getStartOffset(), region.getStartOffset());
        return startOffset < (endOffset = Math.min(this.getEndOffset(), region.getEndOffset()));
    }

    default public @Nullable TextRegion intersectionNonEmpty(TextRegion region) {
        int endOffset;
        int thisStartOffset = this.getStartOffset();
        int thisEndOffset = this.getEndOffset();
        int startOffset = Math.max(thisStartOffset, region.getStartOffset());
        if (startOffset < (endOffset = Math.min(thisEndOffset, region.getEndOffset()))) {
            return startOffset == thisStartOffset && endOffset == thisEndOffset ? this : new BasicTextRegion(startOffset, endOffset);
        }
        return null;
    }
}

