/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.update;

import org.eclipse.statet.internal.rhelp.core.REnvHelpIndexChecker;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpManager;
import org.eclipse.statet.rj.renv.core.RPkgBuilt;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class REnvIndexChecker {
    public static final int NOT_AVAILABLE = -1;
    public static final int UP_TO_DATE = 0;
    public static final int COMPLETE = 1;
    public static final int PACKAGES = 2;
    private final REnvHelpIndexChecker index;
    private final RPkgManager rPkgManager;

    public REnvIndexChecker(REnvHelpConfiguration rEnvConfig, RHelpManager rHelpManager, RPkgManager rPkgManager) {
        this.index = new REnvHelpIndexChecker(rHelpManager, rEnvConfig);
        this.rPkgManager = rPkgManager;
    }

    public int check(RService r, ProgressMonitor m) throws StatusException {
        Exception errorCause = null;
        try {
            if (!this.index.beginCheck()) {
                return -1;
            }
            if (this.index.needsComplete()) {
                return 1;
            }
            RPkgManagerDataset rPkgDataset = this.rPkgManager.getDataset();
            if (rPkgDataset == null) {
                return -1;
            }
            RPkgCompilation installed = rPkgDataset.getInstalled();
            this.index.beginPackageCheck();
            for (String pkgName : installed.getNames()) {
                RPkgBuilt pkgInfo = (RPkgBuilt)installed.getFirst(pkgName);
                if (pkgInfo == null) continue;
                this.index.checkPackage(pkgInfo);
            }
            this.index.endPackageCheck();
            if (this.index.needsComplete()) {
                return 1;
            }
            if (this.index.hasPackageChanges()) {
                return 2;
            }
            return 0;
        }
        catch (Exception e) {
            this.index.cancelCheck();
            errorCause = e;
        }
        finally {
            this.index.finalCheck();
        }
        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", "An error occurred when checking the package data.", (Throwable)errorCause));
    }

    public boolean wasAlreadyReported() {
        return !this.index.hasNewChanges();
    }

    public int getNewPackageCount() {
        return this.index.getNewPackageCount();
    }

    public int getChangedPackageCount() {
        return this.index.getChangedPackageCount();
    }

    public void release() {
        this.index.release();
    }
}

